/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients.aws.s3;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.cloud.clients.ICloudBufferedWriter;
import org.apache.asterix.cloud.clients.profiler.IRequestProfiler;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class S3BufferedWriter
implements ICloudBufferedWriter {
    private static final int MAX_RETRIES = 3;
    private static final Logger LOGGER = LogManager.getLogger();
    private final S3Client s3Client;
    private final IRequestProfiler profiler;
    private final String bucket;
    private final String path;
    private final List<CompletedPart> partQueue;
    private String uploadId;
    private int partNumber;

    public S3BufferedWriter(S3Client s3client, IRequestProfiler profiler, String bucket, String path) {
        this.s3Client = s3client;
        this.profiler = profiler;
        this.bucket = bucket;
        this.path = path;
        this.partQueue = new ArrayList<CompletedPart>();
    }

    @Override
    public int upload(InputStream stream, int length) {
        this.profiler.objectMultipartUpload();
        this.setUploadId();
        UploadPartRequest upReq = (UploadPartRequest)UploadPartRequest.builder().uploadId(this.uploadId).partNumber(Integer.valueOf(this.partNumber)).bucket(this.bucket).key(this.path).build();
        String etag = this.s3Client.uploadPart(upReq, RequestBody.fromInputStream((InputStream)stream, (long)length)).eTag();
        this.partQueue.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.partNumber)).eTag(etag).build());
        return this.partNumber++;
    }

    @Override
    public boolean isEmpty() {
        return this.uploadId == null;
    }

    @Override
    public void finish() throws HyracksDataException {
        if (this.uploadId == null) {
            throw new IllegalStateException("Cannot finish without writing any bytes");
        }
        CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(this.partQueue).build();
        CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucket).key(this.path).uploadId(this.uploadId).multipartUpload(completedMultipartUpload).build();
        int retries = 0;
        while (true) {
            try {
                this.completeMultipartUpload(completeMultipartUploadRequest);
                break;
            }
            catch (Exception e) {
                if (++retries == 3) {
                    throw HyracksDataException.create((Throwable)e);
                }
                LOGGER.info(() -> "S3 storage write retry, encountered: " + e.getMessage());
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(retries < 2 ? 1L : 2L));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create((Throwable)ex);
                }
            }
        }
        this.log("FINISHED");
    }

    @Override
    public void abort() throws HyracksDataException {
        if (this.uploadId == null) {
            return;
        }
        this.s3Client.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.bucket).key(this.path).uploadId(this.uploadId).build());
        LOGGER.warn("Multipart upload for {} was aborted", (Object)this.path);
    }

    private void completeMultipartUpload(CompleteMultipartUploadRequest request) throws HyracksDataException {
        this.profiler.objectMultipartUpload();
        try {
            this.s3Client.completeMultipartUpload(request);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void setUploadId() {
        if (this.uploadId == null) {
            CreateMultipartUploadRequest uploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucket).key(this.path).build();
            CreateMultipartUploadResponse uploadResp = this.s3Client.createMultipartUpload(uploadRequest);
            this.uploadId = uploadResp.uploadId();
            this.partNumber = 1;
            this.log("STARTED");
        }
    }

    private void log(String op) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} multipart upload for {}", (Object)op, (Object)this.path);
        }
    }
}

