/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.net.protocols.tcp.ITCPConnectionListener;
import org.apache.hyracks.net.protocols.tcp.TCPConnection;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPEndpoint {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ITCPConnectionListener connectionListener;
    private final int nThreads;
    private ServerSocketChannel serverSocketChannel;
    private InetSocketAddress localAddress;
    private IOThread[] ioThreads;
    private int nextThread;
    private final ISocketChannelFactory socketChannelFactory;

    public TCPEndpoint(ITCPConnectionListener connectionListener, int nThreads, ISocketChannelFactory socketChannelFactory) {
        this.connectionListener = connectionListener;
        this.nThreads = nThreads;
        this.socketChannelFactory = socketChannelFactory;
    }

    public void start(InetSocketAddress localAddress) throws IOException {
        if (localAddress != null) {
            this.serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            serverSocket.bind(localAddress);
            this.localAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
        }
        this.ioThreads = new IOThread[this.nThreads];
        for (int i = 0; i < this.ioThreads.length; ++i) {
            this.ioThreads[i] = new IOThread();
        }
        if (localAddress != null) {
            for (IOThread ioThread : this.ioThreads) {
                ioThread.registerServerSocket(this.serverSocketChannel);
            }
        }
        for (IOThread ioThread : this.ioThreads) {
            ioThread.start();
        }
    }

    private synchronized int getNextThread() {
        int result = this.nextThread;
        this.nextThread = (this.nextThread + 1) % this.nThreads;
        return result;
    }

    public void initiateConnection(InetSocketAddress remoteAddress) {
        int targetThread = this.getNextThread();
        this.ioThreads[targetThread].initiateConnection(remoteAddress);
    }

    private void distributeIncomingConnection(SocketChannel channel) {
        int targetThread = this.getNextThread();
        this.ioThreads[targetThread].addIncomingConnection(channel);
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public String toString() {
        return "TCPEndpoint [Local Address: " + this.localAddress + "]";
    }

    private class IOThread
    extends Thread {
        private final List<InetSocketAddress> pendingConnections;
        private final List<InetSocketAddress> workingPendingConnections;
        private final List<SocketChannel> incomingConnections;
        private final List<SocketChannel> workingIncomingConnections;
        private final List<PendingHandshakeConnection> handshakeCompletedConnections;
        private final Selector selector;

        public IOThread() throws IOException {
            super("TCPEndpoint IO Thread [" + TCPEndpoint.this.localAddress + "]");
            this.setDaemon(true);
            this.setPriority(5);
            this.pendingConnections = new ArrayList<InetSocketAddress>();
            this.workingPendingConnections = new ArrayList<InetSocketAddress>();
            this.incomingConnections = new ArrayList<SocketChannel>();
            this.workingIncomingConnections = new ArrayList<SocketChannel>();
            this.handshakeCompletedConnections = new ArrayList<PendingHandshakeConnection>();
            this.selector = Selector.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block21: while (true) {
                        n = this.selector.select();
                        this.collectOutstandingWork();
                        if (!this.workingPendingConnections.isEmpty()) {
                            for (InetSocketAddress address : this.workingPendingConnections) {
                                channel = SocketChannel.open();
                                this.register(channel);
                                connect = false;
                                failure = false;
                                try {
                                    connect = channel.connect(address);
                                }
                                catch (IOException e) {
                                    failure = true;
                                    var8_10 = TCPEndpoint.this.connectionListener;
                                    synchronized (var8_10) {
                                        TCPEndpoint.this.connectionListener.connectionFailure(address, e);
                                    }
                                }
                                if (failure) continue;
                                if (!connect) {
                                    key = channel.register(this.selector, 8);
                                    key.attach(address);
                                    continue;
                                }
                                this.socketConnected(address, channel);
                            }
                            this.workingPendingConnections.clear();
                        }
                        if (!this.workingIncomingConnections.isEmpty()) {
                            for (Object channel : this.workingIncomingConnections) {
                                this.register((SocketChannel)channel);
                                this.connectionReceived((SocketChannel)channel);
                            }
                            this.workingIncomingConnections.clear();
                        }
                        var2_3 = this.handshakeCompletedConnections;
                        synchronized (var2_3) {
                            if (!this.handshakeCompletedConnections.isEmpty()) {
                                channel = this.handshakeCompletedConnections.iterator();
                                while (channel.hasNext()) {
                                    conn = (PendingHandshakeConnection)channel.next();
                                    this.handshakeCompleted(conn);
                                }
                                this.handshakeCompletedConnections.clear();
                            }
                        }
                        if (n <= 0) continue;
                        i = this.selector.selectedKeys().iterator();
                        while (true) {
                            if (i.hasNext()) ** break;
                            continue block21;
                            key = i.next();
                            i.remove();
                            sc = key.channel();
                            readable = key.isReadable();
                            writable = key.isWritable();
                            if (readable || writable) {
                                connection = (TCPConnection)key.attachment();
                                try {
                                    connection.getEventListener().notifyIOReady(connection, readable, writable);
                                }
                                catch (Exception e) {
                                    TCPEndpoint.LOGGER.error("Unexpected tcp io error in connection {}", (Object)connection, (Object)e);
                                    connection.getEventListener().notifyIOError(e);
                                    connection.close();
                                    var9_13 = TCPEndpoint.this.connectionListener;
                                    synchronized (var9_13) {
                                        TCPEndpoint.this.connectionListener.connectionClosed(connection);
                                        continue;
                                    }
                                }
                            }
                            if (key.isAcceptable()) {
                                if (!IOThread.$assertionsDisabled && sc != TCPEndpoint.this.serverSocketChannel) {
                                    throw new AssertionError();
                                }
                                channel = TCPEndpoint.this.serverSocketChannel.accept();
                                TCPEndpoint.this.distributeIncomingConnection(channel);
                                continue;
                            }
                            if (!key.isConnectable()) continue;
                            channel = (SocketChannel)sc;
                            finishConnect = false;
                            try {
                                finishConnect = channel.finishConnect();
                            }
                            catch (IOException e) {
                                TCPEndpoint.LOGGER.error("Failed to finish connect to channel {}", key.attachment(), (Object)e);
                                key.cancel();
                                var10_16 = TCPEndpoint.this.connectionListener;
                                synchronized (var10_16) {
                                    TCPEndpoint.this.connectionListener.connectionFailure((InetSocketAddress)key.attachment(), e);
                                }
                            }
                            if (!finishConnect) continue;
                            this.socketConnected((InetSocketAddress)key.attachment(), channel);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    TCPEndpoint.LOGGER.error("Error in TCPEndpoint {}", (Object)TCPEndpoint.this, (Object)e);
                    continue;
                }
                break;
            }
        }

        private void handshakeCompleted(PendingHandshakeConnection conn) {
            try {
                if (conn.handshakeSuccess) {
                    SelectionKey key = conn.socketChannel.getSocketChannel().register(this.selector, 0);
                    TCPConnection tcpConn = new TCPConnection(TCPEndpoint.this, conn.socketChannel, key, this.selector, conn.type);
                    key.attach(tcpConn);
                    switch (conn.type) {
                        case INCOMING: {
                            this.connectionAccepted(tcpConn);
                            break;
                        }
                        case OUTGOING: {
                            this.connectionEstablished(tcpConn);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown connection type: " + conn.type);
                        }
                    }
                } else {
                    this.handleHandshakeFailure(conn);
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to establish connection after handshake", (Throwable)e);
                this.handleHandshakeFailure(conn);
            }
        }

        synchronized void initiateConnection(InetSocketAddress remoteAddress) {
            this.pendingConnections.add(remoteAddress);
            this.selector.wakeup();
        }

        synchronized void addIncomingConnection(SocketChannel channel) {
            this.incomingConnections.add(channel);
            this.selector.wakeup();
        }

        void registerServerSocket(ServerSocketChannel serverSocketChannel) throws IOException {
            serverSocketChannel.configureBlocking(false);
            serverSocketChannel.register(this.selector, 16);
        }

        private synchronized void collectOutstandingWork() {
            if (!this.pendingConnections.isEmpty()) {
                this.workingPendingConnections.addAll(this.pendingConnections);
                this.pendingConnections.clear();
            }
            if (!this.incomingConnections.isEmpty()) {
                this.workingIncomingConnections.addAll(this.incomingConnections);
                this.incomingConnections.clear();
            }
        }

        private void register(SocketChannel channel) throws IOException {
            NetworkUtil.configure((SocketChannel)channel);
            channel.configureBlocking(false);
        }

        private void socketConnected(InetSocketAddress remoteAddress, SocketChannel channel) {
            ISocketChannel socketChannel = TCPEndpoint.this.socketChannelFactory.createClientChannel(channel);
            PendingHandshakeConnection conn = new PendingHandshakeConnection(socketChannel, remoteAddress, TCPConnection.ConnectionType.OUTGOING);
            if (socketChannel.requiresHandshake()) {
                this.asyncHandshake(conn);
            } else {
                this.handshakeCompleted(true, conn);
            }
        }

        private void connectionReceived(SocketChannel channel) {
            ISocketChannel socketChannel = TCPEndpoint.this.socketChannelFactory.createServerChannel(channel);
            PendingHandshakeConnection conn = new PendingHandshakeConnection(socketChannel, null, TCPConnection.ConnectionType.INCOMING);
            if (socketChannel.requiresHandshake()) {
                this.asyncHandshake(conn);
            } else {
                this.handshakeCompleted(true, conn);
            }
        }

        private void asyncHandshake(PendingHandshakeConnection connection) {
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> ((ISocketChannel)connection.socketChannel).handshake()).exceptionally(ex -> false)).thenAccept(handshakeSuccess -> this.handleHandshakeCompletion((Boolean)handshakeSuccess, connection));
        }

        private void handleHandshakeCompletion(Boolean handshakeSuccess, PendingHandshakeConnection conn) {
            this.handshakeCompleted(handshakeSuccess, conn);
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handshakeCompleted(Boolean handshakeSuccess, PendingHandshakeConnection conn) {
            conn.handshakeSuccess = handshakeSuccess;
            List<PendingHandshakeConnection> list = this.handshakeCompletedConnections;
            synchronized (list) {
                this.handshakeCompletedConnections.add(conn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectionEstablished(TCPConnection connection) {
            ITCPConnectionListener iTCPConnectionListener = TCPEndpoint.this.connectionListener;
            synchronized (iTCPConnectionListener) {
                TCPEndpoint.this.connectionListener.connectionEstablished(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectionAccepted(TCPConnection connection) {
            ITCPConnectionListener iTCPConnectionListener = TCPEndpoint.this.connectionListener;
            synchronized (iTCPConnectionListener) {
                TCPEndpoint.this.connectionListener.acceptedConnection(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleHandshakeFailure(PendingHandshakeConnection conn) {
            NetworkUtil.closeQuietly((Closeable)conn.socketChannel);
            if (conn.type == TCPConnection.ConnectionType.OUTGOING) {
                ITCPConnectionListener iTCPConnectionListener = TCPEndpoint.this.connectionListener;
                synchronized (iTCPConnectionListener) {
                    TCPEndpoint.this.connectionListener.connectionFailure(conn.address, new IOException("handshake failure"));
                }
            }
        }
    }

    private static class PendingHandshakeConnection {
        private final ISocketChannel socketChannel;
        private final TCPConnection.ConnectionType type;
        private final InetSocketAddress address;
        private boolean handshakeSuccess = false;

        PendingHandshakeConnection(ISocketChannel socketChannel, InetSocketAddress address, TCPConnection.ConnectionType connectionType) {
            this.socketChannel = socketChannel;
            this.type = connectionType;
            this.address = address;
        }
    }
}

