/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.List;
import java.util.Objects;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class FeedConnection
implements IMetadataEntity<FeedConnection> {
    private static final long serialVersionUID = 3L;
    private final EntityId feedId;
    private final String connectionId;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String feedName;
    private final String datasetName;
    private final String policyName;
    private final String whereClauseBody;
    private final String outputType;
    private final List<FunctionSignature> appliedFunctions;

    public FeedConnection(String databaseName, DataverseName dataverseName, String feedName, String datasetName, List<FunctionSignature> appliedFunctions, String policyName, String whereClauseBody, String outputType) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = dataverseName;
        this.feedName = feedName;
        this.datasetName = datasetName;
        this.appliedFunctions = appliedFunctions;
        this.connectionId = feedName + ":" + datasetName;
        this.policyName = policyName;
        this.whereClauseBody = whereClauseBody == null ? "" : whereClauseBody;
        this.outputType = outputType;
        this.feedId = new EntityId("Feed", databaseName, dataverseName, feedName);
    }

    public List<FunctionSignature> getAppliedFunctions() {
        return this.appliedFunctions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeedConnection)) {
            return false;
        }
        return ((FeedConnection)other).getConnectionId().equals(this.connectionId);
    }

    public int hashCode() {
        return this.connectionId.hashCode();
    }

    @Override
    public FeedConnection addToCache(MetadataCache cache) {
        return null;
    }

    @Override
    public FeedConnection dropFromCache(MetadataCache cache) {
        return null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getWhereClauseBody() {
        return this.whereClauseBody;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public EntityId getFeedId() {
        return this.feedId;
    }

    public boolean containsFunction(FunctionSignature signature) {
        return this.appliedFunctions.contains(signature);
    }
}

