/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.file;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import org.apache.hyracks.api.compression.ICompressorDecompressor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.BufferCacheHeaderHelper;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.compression.file.CompressedFileManager;
import org.apache.hyracks.storage.common.compression.file.CompressedFileReference;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class CompressedBufferedFileHandle
extends BufferedFileHandle {
    private final FileReference lafFileRef;
    private volatile CompressedFileManager compressedFileManager;

    protected CompressedBufferedFileHandle(int fileId, FileReference lafFileRef, BufferCache bufferCache, IIOManager ioManager, BlockingQueue<BufferCacheHeaderHelper> headerPageCache, IPageReplacementStrategy pageReplacementStrategy) {
        super(fileId, bufferCache, ioManager, headerPageCache, pageReplacementStrategy);
        this.lafFileRef = lafFileRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(CachedPage cPage) throws HyracksDataException {
        BufferCacheHeaderHelper header = this.checkoutHeaderHelper();
        try {
            this.compressedFileManager.setCompressedPageInfo(cPage);
            long bytesRead = this.readToBuffer(header.prepareRead(cPage.getCompressedPageSize()), this.getFirstPageOffset(cPage));
            if (!this.verifyBytesRead(cPage.getCompressedPageSize(), bytesRead)) {
                return;
            }
            ByteBuffer cBuffer = header.processHeader(cPage);
            ByteBuffer uBuffer = cPage.getBuffer();
            this.fixBufferPointers(uBuffer, 0);
            if (cPage.getCompressedPageSize() < this.bufferCache.getPageSizeWithHeader()) {
                this.uncompressToPageBuffer(cBuffer, uBuffer);
            } else {
                cPage.getBuffer().put(cBuffer);
            }
            int totalPages = cPage.getFrameSizeMultiplier();
            if (totalPages > 1) {
                this.pageReplacementStrategy.fixupCapacityOnLargeRead(cPage);
                this.readExtraPages(cPage, cBuffer);
            }
        }
        finally {
            this.returnHeaderHelper(header);
        }
    }

    private void readExtraPages(CachedPage cPage, ByteBuffer cBuffer) throws HyracksDataException {
        ByteBuffer uBuffer = cPage.getBuffer();
        int totalPages = cPage.getFrameSizeMultiplier();
        for (int i = 1; i < totalPages; ++i) {
            this.fixBufferPointers(uBuffer, i);
            this.compressedFileManager.setExtraCompressedPageInfo(cPage, i - 1);
            if (cPage.getCompressedPageSize() < this.bufferCache.getPageSize()) {
                cBuffer.position(0);
                cBuffer.limit(cPage.getCompressedPageSize());
                this.readToBuffer(cBuffer, this.getExtraPageOffset(cPage));
                cBuffer.flip();
                this.uncompressToPageBuffer(cBuffer, cPage.getBuffer());
                continue;
            }
            this.readToBuffer(uBuffer, this.getExtraPageOffset(cPage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(CachedPage cPage, BufferCacheHeaderHelper header, int totalPages, int extraBlockPageId) throws HyracksDataException {
        try {
            long bytesWritten;
            long expectedBytesWritten;
            ByteBuffer cBuffer = header.prepareWrite(cPage, this.getRequiredBufferSize());
            ByteBuffer uBuffer = cPage.getBuffer();
            long pageId = cPage.getDiskPageId();
            this.fixBufferPointers(uBuffer, 0);
            if (this.compressToWriteBuffer(uBuffer, cBuffer) < this.bufferCache.getPageSize()) {
                cBuffer.position(0);
                long offset = this.compressedFileManager.writePageInfo(pageId, cBuffer.remaining());
                expectedBytesWritten = cBuffer.limit();
                bytesWritten = this.writeToFile(cBuffer, offset);
            } else {
                ByteBuffer[] buffers = header.prepareWrite(cPage);
                long offset = this.compressedFileManager.writePageInfo(pageId, this.bufferCache.getPageSizeWithHeader());
                expectedBytesWritten = (long)buffers[0].limit() + (long)buffers[1].limit();
                bytesWritten = this.writeToFile(buffers, offset);
            }
            this.verifyBytesWritten(expectedBytesWritten, bytesWritten);
            if (totalPages > 1) {
                this.writeExtraCompressedPages(cPage, cBuffer, totalPages, extraBlockPageId);
            }
        }
        finally {
            this.returnHeaderHelper(header);
        }
    }

    private void writeExtraCompressedPages(CachedPage cPage, ByteBuffer cBuffer, int totalPages, int extraBlockPageId) throws HyracksDataException {
        ByteBuffer uBuffer = cPage.getBuffer();
        long expectedBytesWritten = 0L;
        long bytesWritten = 0L;
        for (int i = 1; i < totalPages; ++i) {
            this.fixBufferPointers(uBuffer, i);
            cBuffer.position(0);
            ByteBuffer writeBuffer = this.compressToWriteBuffer(uBuffer, cBuffer) < this.bufferCache.getPageSize() ? cBuffer : uBuffer;
            int length = writeBuffer.remaining();
            long offset = this.compressedFileManager.writeExtraPageInfo(extraBlockPageId, length, i - 1);
            expectedBytesWritten += (long)length;
            bytesWritten += this.writeToFile(writeBuffer, offset);
        }
        this.verifyBytesWritten(expectedBytesWritten, bytesWritten);
    }

    @Override
    public void open(FileReference fileRef) throws HyracksDataException {
        CompressedFileReference cFileRef = (CompressedFileReference)fileRef;
        this.compressedFileManager = new CompressedFileManager(this.bufferCache, cFileRef, (IIOManager)this.ioManager);
        this.compressedFileManager.open();
        super.open(fileRef);
    }

    @Override
    public void close() throws HyracksDataException {
        if (this.hasBeenOpened()) {
            this.compressedFileManager.close();
        }
        super.close();
    }

    @Override
    public void purge() throws HyracksDataException {
        this.compressedFileManager.purge();
        super.purge();
    }

    @Override
    public void markAsDeleted() throws HyracksDataException {
        if (this.hasBeenOpened()) {
            this.compressedFileManager.delete();
            this.compressedFileManager = null;
        } else {
            this.bufferCache.deleteFile(this.lafFileRef);
        }
        super.markAsDeleted();
    }

    @Override
    public void force(boolean metadata) throws HyracksDataException {
        this.compressedFileManager.force(metadata);
        super.force(metadata);
    }

    @Override
    public int getNumberOfPages() {
        return this.compressedFileManager.getNumberOfPages();
    }

    @Override
    protected long getFirstPageOffset(CachedPage cPage) {
        return cPage.getCompressedPageOffset();
    }

    @Override
    protected long getExtraPageOffset(CachedPage cPage) {
        return this.getFirstPageOffset(cPage);
    }

    @Override
    public ICompressedPageWriter getCompressedPageWriter() {
        return this.compressedFileManager.getCompressedPageWriter();
    }

    private void fixBufferPointers(ByteBuffer uBuffer, int i) {
        uBuffer.position(this.bufferCache.getPageSize() * i);
        uBuffer.limit(uBuffer.position() + this.bufferCache.getPageSize());
    }

    private void uncompressToPageBuffer(ByteBuffer cBuffer, ByteBuffer uBuffer) throws HyracksDataException {
        ICompressorDecompressor compDecomp = this.compressedFileManager.getCompressorDecompressor();
        compDecomp.uncompress(cBuffer, uBuffer);
        this.verifyUncompressionSize(this.bufferCache.getPageSize(), uBuffer.remaining());
    }

    private int compressToWriteBuffer(ByteBuffer uBuffer, ByteBuffer cBuffer) throws HyracksDataException {
        ICompressorDecompressor compDecomp = this.compressedFileManager.getCompressorDecompressor();
        compDecomp.compress(uBuffer, cBuffer);
        return cBuffer.remaining();
    }

    private int getRequiredBufferSize() {
        ICompressorDecompressor compDecomp = this.compressedFileManager.getCompressorDecompressor();
        return compDecomp.computeCompressedBufferSize(this.bufferCache.getPageSize());
    }

    private void verifyUncompressionSize(int expected, int actual) {
        if (expected != actual) {
            this.throwException("Uncompressed", expected, actual);
        }
    }
}

