/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class WindowOperator
extends AbstractOperatorWithNestedPlans {
    public static final int FRAME_MAX_OBJECTS_UNLIMITED = -1;
    private final List<Mutable<ILogicalExpression>> partitionExpressions = new ArrayList<Mutable<ILogicalExpression>>();
    private final List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions;
    private final List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExpressions;
    private final List<Mutable<ILogicalExpression>> frameStartExpressions;
    private final List<Mutable<ILogicalExpression>> frameStartValidationExpressions;
    private final List<Mutable<ILogicalExpression>> frameEndExpressions;
    private final List<Mutable<ILogicalExpression>> frameEndValidationExpressions;
    private final List<Mutable<ILogicalExpression>> frameExcludeExpressions;
    private int frameExcludeNegationStartIdx;
    private final Mutable<ILogicalExpression> frameExcludeUnaryExpression;
    private final Mutable<ILogicalExpression> frameOffsetExpression;
    private int frameMaxObjects;
    private final List<LogicalVariable> variables;
    private final List<Mutable<ILogicalExpression>> expressions;

    public WindowOperator(List<Mutable<ILogicalExpression>> partitionExpressions, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions) {
        this(partitionExpressions, orderExpressions, null, null, null, null, null, null, -1, null, null, -1);
    }

    public WindowOperator(List<Mutable<ILogicalExpression>> partitionExpressions, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExpressions, List<Mutable<ILogicalExpression>> frameStartExpressions, List<Mutable<ILogicalExpression>> frameStartValidationExpressions, List<Mutable<ILogicalExpression>> frameEndExpressions, List<Mutable<ILogicalExpression>> frameEndValidationExpressions, List<Mutable<ILogicalExpression>> frameExcludeExpressions, int frameExcludeNegationStartIdx, ILogicalExpression frameExcludeUnaryExpression, ILogicalExpression frameOffsetExpression, int frameMaxObjects) {
        if (partitionExpressions != null) {
            this.partitionExpressions.addAll(partitionExpressions);
        }
        this.orderExpressions = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>();
        if (orderExpressions != null) {
            this.orderExpressions.addAll(orderExpressions);
        }
        this.frameValueExpressions = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>();
        if (frameValueExpressions != null) {
            this.frameValueExpressions.addAll(frameValueExpressions);
        }
        this.frameStartExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        if (frameStartExpressions != null) {
            this.frameStartExpressions.addAll(frameStartExpressions);
        }
        this.frameStartValidationExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        if (frameStartValidationExpressions != null) {
            this.frameStartValidationExpressions.addAll(frameStartValidationExpressions);
        }
        this.frameEndExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        if (frameEndExpressions != null) {
            this.frameEndExpressions.addAll(frameEndExpressions);
        }
        this.frameEndValidationExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        if (frameEndValidationExpressions != null) {
            this.frameEndValidationExpressions.addAll(frameEndValidationExpressions);
        }
        this.frameExcludeExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        if (frameExcludeExpressions != null) {
            this.frameExcludeExpressions.addAll(frameExcludeExpressions);
        }
        this.frameExcludeNegationStartIdx = frameExcludeNegationStartIdx;
        this.frameExcludeUnaryExpression = new MutableObject((Object)frameExcludeUnaryExpression);
        this.frameOffsetExpression = new MutableObject((Object)frameOffsetExpression);
        this.variables = new ArrayList<LogicalVariable>();
        this.expressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.setFrameMaxObjects(frameMaxObjects);
    }

    public WindowOperator(List<Mutable<ILogicalExpression>> partitionExpressions, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExpressions, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExpressions, List<Mutable<ILogicalExpression>> frameStartExpressions, List<Mutable<ILogicalExpression>> frameStartValidationExpressions, List<Mutable<ILogicalExpression>> frameEndExpressions, List<Mutable<ILogicalExpression>> frameEndValidationExpressions, List<Mutable<ILogicalExpression>> frameExcludeExpressions, int frameExcludeNegationStartIdx, ILogicalExpression frameExcludeUnaryExpression, ILogicalExpression frameOffsetExpression, int frameMaxObjects, List<LogicalVariable> variables, List<Mutable<ILogicalExpression>> expressions, List<ILogicalPlan> nestedPlans) {
        this(partitionExpressions, orderExpressions, frameValueExpressions, frameStartExpressions, frameStartValidationExpressions, frameEndExpressions, frameEndValidationExpressions, frameExcludeExpressions, frameExcludeNegationStartIdx, frameExcludeUnaryExpression, frameOffsetExpression, frameMaxObjects);
        if (variables != null) {
            this.variables.addAll(variables);
        }
        if (expressions != null) {
            this.expressions.addAll(expressions);
        }
        if (nestedPlans != null) {
            this.nestedPlans.addAll(nestedPlans);
        }
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.WINDOW;
    }

    public List<Mutable<ILogicalExpression>> getPartitionExpressions() {
        return this.partitionExpressions;
    }

    public List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> getOrderExpressions() {
        return this.orderExpressions;
    }

    public List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> getFrameValueExpressions() {
        return this.frameValueExpressions;
    }

    public List<Mutable<ILogicalExpression>> getFrameStartExpressions() {
        return this.frameStartExpressions;
    }

    public List<Mutable<ILogicalExpression>> getFrameStartValidationExpressions() {
        return this.frameStartValidationExpressions;
    }

    public List<Mutable<ILogicalExpression>> getFrameEndExpressions() {
        return this.frameEndExpressions;
    }

    public List<Mutable<ILogicalExpression>> getFrameEndValidationExpressions() {
        return this.frameEndValidationExpressions;
    }

    public List<Mutable<ILogicalExpression>> getFrameExcludeExpressions() {
        return this.frameExcludeExpressions;
    }

    public int getFrameExcludeNegationStartIdx() {
        return this.frameExcludeNegationStartIdx;
    }

    public void setFrameExcludeNegationStartIdx(int value) {
        this.frameExcludeNegationStartIdx = value;
    }

    public Mutable<ILogicalExpression> getFrameExcludeUnaryExpression() {
        return this.frameExcludeUnaryExpression;
    }

    public Mutable<ILogicalExpression> getFrameOffsetExpression() {
        return this.frameOffsetExpression;
    }

    public int getFrameMaxObjects() {
        return this.frameMaxObjects;
    }

    public void setFrameMaxObjects(int value) {
        this.frameMaxObjects = value < 0 ? -1 : value;
    }

    public List<LogicalVariable> getVariables() {
        return this.variables;
    }

    public List<Mutable<ILogicalExpression>> getExpressions() {
        return this.expressions;
    }

    @Override
    public boolean hasNestedPlans() {
        return !this.nestedPlans.isEmpty();
    }

    @Override
    public void recomputeSchema() {
        super.recomputeSchema();
        this.schema.addAll(this.variables);
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitWindowOperator(this, arg);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        return this.acceptExpressionTransform(visitor, true);
    }

    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor, boolean visitVarRefRequiringExprs) throws AlgebricksException {
        boolean mod = false;
        if (visitVarRefRequiringExprs) {
            for (Mutable<ILogicalExpression> mutable : this.partitionExpressions) {
                mod |= visitor.transform(mutable);
            }
            for (Pair pair : this.orderExpressions) {
                mod |= visitor.transform((Mutable<ILogicalExpression>)((Mutable)pair.second));
            }
            for (Pair pair : this.frameValueExpressions) {
                mod |= visitor.transform((Mutable<ILogicalExpression>)((Mutable)pair.second));
            }
        }
        for (Mutable<ILogicalExpression> mutable : this.frameStartExpressions) {
            mod |= visitor.transform(mutable);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameStartValidationExpressions) {
            mod |= visitor.transform(mutable);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameEndExpressions) {
            mod |= visitor.transform(mutable);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameEndValidationExpressions) {
            mod |= visitor.transform(mutable);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameExcludeExpressions) {
            mod |= visitor.transform(mutable);
        }
        if (this.frameExcludeUnaryExpression.getValue() != null) {
            mod |= visitor.transform(this.frameExcludeUnaryExpression);
        }
        if (this.frameOffsetExpression.getValue() != null) {
            mod |= visitor.transform(this.frameOffsetExpression);
        }
        for (Mutable<ILogicalExpression> mutable : this.expressions) {
            mod |= visitor.transform(mutable);
        }
        return mod;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) {
                target.addAllVariables(sources[0]);
                for (LogicalVariable v : WindowOperator.this.variables) {
                    target.addVariable(v);
                }
            }
        };
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        PropagatingTypeEnvironment env = this.createNestedPlansPropagatingTypeEnvironment(ctx, true);
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            env.setVarType(this.variables.get(i), ctx.getExpressionTypeComputer().getType((ILogicalExpression)this.expressions.get(i).getValue(), ctx.getMetadataProvider(), env));
        }
        return env;
    }

    @Override
    public void getProducedVariablesExceptNestedPlans(Collection<LogicalVariable> vars) {
        vars.addAll(this.variables);
    }

    @Override
    public void getUsedVariablesExceptNestedPlans(Collection<LogicalVariable> vars) {
        for (Mutable<ILogicalExpression> mutable : this.partitionExpressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
        for (Pair pair : this.orderExpressions) {
            ((ILogicalExpression)((Mutable)pair.second).getValue()).getUsedVariables(vars);
        }
        for (Pair pair : this.frameValueExpressions) {
            ((ILogicalExpression)((Mutable)pair.second).getValue()).getUsedVariables(vars);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameStartExpressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameStartValidationExpressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameEndExpressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameEndValidationExpressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
        for (Mutable<ILogicalExpression> mutable : this.frameExcludeExpressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
        if (this.frameExcludeUnaryExpression.getValue() != null) {
            ((ILogicalExpression)this.frameExcludeUnaryExpression.getValue()).getUsedVariables(vars);
        }
        if (this.frameOffsetExpression.getValue() != null) {
            ((ILogicalExpression)this.frameOffsetExpression.getValue()).getUsedVariables(vars);
        }
        for (Mutable<ILogicalExpression> mutable : this.expressions) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(vars);
        }
    }

    @Override
    public boolean requiresVariableReferenceExpressions() {
        return false;
    }

    public List<LogicalVariable> getPartitionVarList() {
        ArrayList<LogicalVariable> varList = new ArrayList<LogicalVariable>(this.partitionExpressions.size());
        for (Mutable<ILogicalExpression> pe : this.partitionExpressions) {
            ILogicalExpression partExpr = (ILogicalExpression)pe.getValue();
            if (partExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable var = ((VariableReferenceExpression)partExpr).getVariableReference();
            varList.add(var);
        }
        return varList;
    }

    public List<OrderColumn> getOrderColumnList() {
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>(this.orderExpressions.size());
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : this.orderExpressions) {
            ILogicalExpression orderExpr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (orderExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable var = ((VariableReferenceExpression)orderExpr).getVariableReference();
            orderColumns.add(new OrderColumn(var, ((OrderOperator.IOrder)p.first).getKind()));
        }
        return orderColumns;
    }
}

