/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.prettyprint;

import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksStringBuilderWriter;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public abstract class AbstractLogicalOperatorPrettyPrintVisitor<T>
implements ILogicalOperatorVisitor<Void, T> {
    protected static final String CARDINALITY = "cardinality";
    protected static final String OP_COST_LOCAL = "op-cost";
    protected static final String OP_COST_TOTAL = "total-cost";
    protected final ILogicalExpressionVisitor<String, T> exprVisitor;
    protected final AlgebricksStringBuilderWriter buffer = new AlgebricksStringBuilderWriter(256);

    public AbstractLogicalOperatorPrettyPrintVisitor(ILogicalExpressionVisitor<String, T> exprVisitor) {
        this.exprVisitor = exprVisitor;
    }

    public static void printPhysicalOps(ILogicalPlan plan, AlgebricksStringBuilderWriter out, int indent, boolean verbose) throws AlgebricksException {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            AbstractLogicalOperatorPrettyPrintVisitor.printPhysicalOperator((AbstractLogicalOperator)root.getValue(), indent, out, verbose);
        }
    }

    protected void resetState() {
        this.buffer.getBuilder().setLength(0);
    }

    protected double getPlanCardinality(ILogicalOperator op) {
        Double planCard = null;
        if (op.getOperatorTag() == LogicalOperatorTag.DISTRIBUTE_RESULT) {
            planCard = (Double)this.getAnnotationValue(op, "OUTPUT_CARDINALITY");
        }
        return planCard != null ? planCard : 0.0;
    }

    protected double getPlanCost(ILogicalOperator op) {
        Double planCost = null;
        if (op.getOperatorTag() == LogicalOperatorTag.DISTRIBUTE_RESULT) {
            planCost = (Double)this.getAnnotationValue(op, "TOTAL_COST");
        }
        return planCost != null ? planCost : 0.0;
    }

    protected double getOpCardinality(ILogicalOperator op) {
        Double opCard = op.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN ? (((DataSourceScanOperator)op).getSelectCondition() != null ? (Double)this.getAnnotationValue(op, "OUTPUT_CARDINALITY") : (Double)this.getAnnotationValue(op, "INPUT_CARDINALITY")) : (Double)this.getAnnotationValue(op, "OUTPUT_CARDINALITY");
        return opCard != null ? opCard : 0.0;
    }

    protected double getOpLocalCost(ILogicalOperator op) {
        Double opLocalCost = (Double)this.getAnnotationValue(op, "OP_COST");
        return opLocalCost != null ? opLocalCost : 0.0;
    }

    protected double getOpTotalCost(ILogicalOperator op) {
        Double opTotalCost = (Double)this.getAnnotationValue(op, "TOTAL_COST");
        return opTotalCost != null ? opTotalCost : 0.0;
    }

    protected Object getAnnotationValue(ILogicalOperator op, String key) {
        Map<String, Object> annotations = op.getAnnotations();
        if (annotations != null && annotations.containsKey(key)) {
            return annotations.get(key);
        }
        return null;
    }

    public String toString() {
        return this.buffer.toString();
    }

    String str(Object o) {
        return String.valueOf(o);
    }

    protected static void appendln(AlgebricksStringBuilderWriter buf, String s) {
        buf.append(s);
        buf.append("\n");
    }

    protected static void append(AlgebricksStringBuilderWriter buf, String s) {
        buf.append(s);
    }

    protected static void pad(AlgebricksStringBuilderWriter buf, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
    }

    protected AlgebricksStringBuilderWriter addIndent(int level) {
        for (int i = 0; i < level; ++i) {
            this.buffer.append(' ');
        }
        return this.buffer;
    }

    private static void printPhysicalOperator(AbstractLogicalOperator op, int indent, AlgebricksStringBuilderWriter out, boolean verbose) throws AlgebricksException {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        AbstractLogicalOperatorPrettyPrintVisitor.pad(out, indent);
        AbstractLogicalOperatorPrettyPrintVisitor.appendln(out, "-- " + pOp.toString(verbose) + "  |" + op.getExecutionMode() + "|");
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opNest = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : opNest.getNestedPlans()) {
                AbstractLogicalOperatorPrettyPrintVisitor.pad(out, indent + 8);
                AbstractLogicalOperatorPrettyPrintVisitor.appendln(out, "{");
                AbstractLogicalOperatorPrettyPrintVisitor.printPhysicalOps(p, out, indent + 10, verbose);
                AbstractLogicalOperatorPrettyPrintVisitor.pad(out, indent + 8);
                AbstractLogicalOperatorPrettyPrintVisitor.appendln(out, "}");
            }
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            AbstractLogicalOperatorPrettyPrintVisitor.printPhysicalOperator((AbstractLogicalOperator)i.getValue(), indent + 2, out, verbose);
        }
    }
}

