/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util.dom;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.util.dom.DOMQNameUtils;
import org.apache.woden.internal.util.dom.XPathUtils;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String emptyString = "";

    public static List getAttributes(Element el) {
        String prefix = null;
        Vector<Node> attrs = new Vector<Node>();
        NamedNodeMap attrMap = el.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            String nodename = attrMap.item(i).getNodeName();
            prefix = attrMap.item(i).getPrefix();
            if (ATTR_XMLNS.equals(nodename) || ATTR_XMLNS.equals(prefix)) continue;
            attrs.add(attrMap.item(i));
        }
        return attrs;
    }

    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getAttribute(Element el, String attrName, List remainingAttrs) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
            remainingAttrs.remove(attr);
        }
        return sRet;
    }

    public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        for (Node tempNode = parentEl.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
        }
        return strBuf.toString();
    }

    public static Element getFirstChildElement(Element elem) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element elem) {
        for (Node n = elem.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element elem, String attrName, String attrValue) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !attrValue.equals(DOMUtils.getAttribute((Element)n, attrName))) continue;
            return (Element)n;
        }
        return null;
    }

    public static int countKids(Element elem, short nodeType) {
        int nkids = 0;
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != nodeType) continue;
            ++nkids;
        }
        return nkids;
    }

    public static void throwWSDLException(Element location) throws WSDLException {
        String elName = DOMQNameUtils.newQName(location).toString();
        WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Encountered unexpected element '" + elName + "'.");
        wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(location));
        throw wsdlExc;
    }

    public static void throwWSDLException(Element location, List remainingAttrs) throws WSDLException {
        String elName = DOMQNameUtils.newQName(location).toString();
        StringBuffer sb = new StringBuffer();
        ListIterator i = remainingAttrs.listIterator();
        while (i.hasNext()) {
            String attrName = DOMQNameUtils.newQName((Attr)i.next()).toString();
            sb.append(attrName);
            sb.append(i.hasNext() ? " " : emptyString);
        }
        WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Element '" + elName + "' contained unexpected attributes: '" + sb.toString() + "'");
        wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(location));
        throw wsdlExc;
    }

    public static void printAttribute(String name, String value, PrintWriter pw) {
        if (value != null) {
            pw.print(' ' + name + "=\"" + DOMUtils.cleanString(value) + '\"');
        }
    }

    public static void printQualifiedAttribute(String name, QName value, WSDLElement elem, PrintWriter pw) throws WSDLException {
        if (value != null) {
            DOMUtils.printAttribute(name, DOMUtils.getQualifiedValue(value.getNamespaceURI(), value.getLocalPart(), elem), pw);
        }
    }

    public static String getQualifiedValue(URI namespaceURI, String localPart, WSDLElement elem) throws WSDLException {
        String prefix = null;
        if (namespaceURI != null && !namespaceURI.toString().equals(emptyString)) {
            prefix = elem.getNamespacePrefix(namespaceURI);
        }
        String qv = (prefix != null && !prefix.equals(emptyString) ? prefix + ":" : emptyString) + localPart;
        return qv;
    }

    public static String getQualifiedValue(String namespaceURI, String localPart, WSDLElement elem) throws WSDLException {
        URI nsUri = null;
        if (namespaceURI != null) {
            try {
                nsUri = new URI(namespaceURI);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return DOMUtils.getQualifiedValue(nsUri, localPart, elem);
    }

    public static String cleanString(String orig) {
        if (orig == null) {
            return emptyString;
        }
        StringBuffer strBuf = new StringBuffer();
        char[] chars = orig.toCharArray();
        boolean inCDATA = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!inCDATA) {
                switch (chars[i]) {
                    case '&': {
                        strBuf.append("&amp;");
                        break;
                    }
                    case '\"': {
                        strBuf.append("&quot;");
                        break;
                    }
                    case '\'': {
                        strBuf.append("&apos;");
                        break;
                    }
                    case '<': {
                        if (chars.length >= i + 9) {
                            String tempStr = new String(chars, i, 9);
                            if (tempStr.equals("<![CDATA[")) {
                                strBuf.append(tempStr);
                                i += 8;
                                inCDATA = true;
                                break;
                            }
                            strBuf.append("&lt;");
                            break;
                        }
                        strBuf.append("&lt;");
                        break;
                    }
                    case '>': {
                        strBuf.append("&gt;");
                        break;
                    }
                    default: {
                        strBuf.append(chars[i]);
                        break;
                    }
                }
                continue;
            }
            strBuf.append(chars[i]);
            if (chars[i] != '>' || chars[i - 1] != ']' || chars[i - 2] != ']') continue;
            inCDATA = false;
        }
        return strBuf.toString();
    }
}

