/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.dispatchers.AbstractServiceDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestURIBasedServiceDispatcher
extends AbstractServiceDispatcher {
    public static final String NAME = "RequestURIBasedServiceDispatcher";
    private static final Log log = LogFactory.getLog(RequestURIBasedServiceDispatcher.class);

    @Override
    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Checking for Service using target endpoint address : " + toEPR.getAddress()));
            }
            String filePart = toEPR.getAddress();
            ConfigurationContext configurationContext = messageContext.getConfigurationContext();
            String serviceOpPart = Utils.getServiceAndOperationPart(filePart, messageContext.getConfigurationContext().getServiceContextPath());
            if (serviceOpPart != null) {
                Map<String, AxisEndpoint> endpoints;
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                AxisService axisService = null;
                String[] parts = serviceOpPart.split("/");
                String serviceName = "";
                for (int count = 0; axisService == null && count < parts.length && count < Constants.MAX_HIERARCHICAL_DEPTH; ++count) {
                    serviceName = count == 0 ? serviceName + parts[count] : serviceName + "/" + parts[count];
                    axisService = registry.getService(serviceName);
                }
                if (axisService != null && (endpoints = axisService.getEndpoints()) != null) {
                    if (endpoints.size() == 1) {
                        messageContext.setProperty("endpoint", endpoints.get(axisService.getEndpointName()));
                    } else {
                        AxisEndpoint endpoint;
                        String endpointName;
                        String[] temp = serviceName.split("/");
                        int periodIndex = temp[temp.length - 1].lastIndexOf(46);
                        if (periodIndex != -1) {
                            endpointName = temp[temp.length - 1].substring(periodIndex + 1);
                            messageContext.setProperty("endpoint", endpoints.get(endpointName));
                        }
                        if ((endpoint = endpoints.get(endpointName = temp[0].substring(temp[0].indexOf(".") + 1))) != null) {
                            messageContext.setProperty("endpoint", endpoint);
                        } else {
                            this.inferEndpoint(messageContext, axisService);
                        }
                    }
                }
                return axisService;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using target endpoint URI, but the service fragment was missing"));
            }
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using null target endpoint URI"));
        }
        return null;
    }

    @Override
    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private void inferEndpoint(MessageContext msgCtx, AxisService service) {
        if (!msgCtx.isServerSide()) {
            return;
        }
        String transport = null;
        TransportInDescription transportIn = msgCtx.getTransportIn();
        if (transportIn != null && (transport = transportIn.getName()) == null) {
            return;
        }
        AxisEndpoint endpoint = null;
        Map<String, AxisEndpoint> endpointMapping = service.getEndpoints();
        String serviceName = service.getName();
        if (msgCtx.isDoingREST()) {
            endpoint = endpointMapping.get(WSDLUtil.getEndpointName(serviceName, transport));
        }
        if (endpoint != null) {
            msgCtx.setProperty("endpoint", endpoint);
        }
    }
}

