/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import jakarta.activation.DataHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.message.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentsAdapter
implements Map<String, DataHandler> {
    private static final Log log = LogFactory.getLog(AttachmentsAdapter.class);
    MessageContext mc;
    String propertyName;

    private AttachmentsAdapter(MessageContext mc, String propertyName) {
        this.mc = mc;
        this.propertyName = propertyName;
    }

    public static void install(MessageContext mc) {
        Object map;
        String propertyName;
        Message m = mc.getMessage();
        if (m == null) {
            return;
        }
        boolean isOutbound = mc.isOutbound();
        String string = propertyName = isOutbound ? "jakarta.xml.ws.binding.attachments.outbound" : "jakarta.xml.ws.binding.attachments.inbound";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Installing AttachmentsAdapter for " + propertyName));
        }
        if ((map = mc.getProperty(propertyName)) instanceof AttachmentsAdapter) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"An AttachmentsAdapter is already installed.  Reusing the existing one.");
            }
            return;
        }
        AttachmentsAdapter aa = new AttachmentsAdapter(mc, propertyName);
        if (map != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The DataHandlers in the existing map (" + propertyName + ") are copied to the AttachmentsAdapter."));
            }
            aa.putAll((Map)map);
        }
        mc.setPropertyNoReturn(propertyName, aa);
    }

    @Override
    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"clear()");
        }
        Message m = this.mc.getMessage();
        Set<String> keys = this.keySet();
        for (String key : keys) {
            m.removeDataHandler(key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Message m = this.mc.getMessage();
        Set<String> keys = this.keySet();
        return keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Message m = this.mc.getMessage();
        Set<String> keys = this.keySet();
        for (String key : keys) {
            DataHandler dh = m.getDataHandler(key);
            if (!dh.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, DataHandler>> entrySet() {
        HashMap<String, DataHandler> tempMap = new HashMap<String, DataHandler>();
        tempMap.putAll(this);
        return tempMap.entrySet();
    }

    @Override
    public DataHandler get(Object key) {
        Message m = this.mc.getMessage();
        DataHandler dh = m.getDataHandler((String)key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("get(" + String.valueOf(key) + ") returns dh=" + String.valueOf(dh)));
        }
        return dh;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        Message m = this.mc.getMessage();
        int i = 0;
        String key = m.getAttachmentID(i);
        while (key != null) {
            keys.add(key);
            key = m.getAttachmentID(++i);
        }
        return keys;
    }

    @Override
    public DataHandler put(String key, DataHandler dh) {
        Message m = this.mc.getMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(" + key + " , " + String.valueOf(dh) + ")"));
        }
        DataHandler old = this.get(key);
        m.addDataHandler(dh, key);
        m.setDoingSWA(true);
        return old;
    }

    @Override
    public void putAll(Map<? extends String, ? extends DataHandler> t) {
        Message m = this.mc.getMessage();
        for (String string : t.keySet()) {
            DataHandler dh = t.get(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("addDataHandler via putAll (" + string + " , " + String.valueOf(dh) + ")"));
            }
            m.addDataHandler(dh, string);
            m.setDoingSWA(true);
        }
    }

    @Override
    public DataHandler remove(Object key) {
        Message m = this.mc.getMessage();
        return m.removeDataHandler((String)key);
    }

    @Override
    public int size() {
        Message m = this.mc.getMessage();
        Set<String> keys = this.keySet();
        return keys.size();
    }

    @Override
    public Collection<DataHandler> values() {
        HashMap<String, DataHandler> tempMap = new HashMap<String, DataHandler>();
        tempMap.putAll(this);
        return tempMap.values();
    }
}

