/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.help;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.cli.Options;
import org.apache.rat.OptionCollection;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.help.AbstractHelp;

public final class Help
extends AbstractHelp {
    private static final String[] NOTES = new String[]{"Rat highlights possible issues.", "Rat reports require interpretation.", "Rat often requires some tuning before it runs well against a project.", "Rat relies on heuristics: it may miss issues"};
    private final PrintWriter writer;

    public Help(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public Help(PrintStream stream) {
        this(new PrintWriter(stream));
    }

    public void printUsage(Options opts) {
        String syntax = String.format("java -jar apache-rat/target/apache-rat-%s.jar [options] [DIR|ARCHIVE]", this.versionInfo.getVersion());
        this.helpFormatter.printHelp(this.writer, syntax, Help.header("Available options"), opts, Help.header("Argument Types"));
        String argumentPadding = this.printArgumentTypes();
        this.writer.println(Help.header("Standard Collections"));
        for (StandardCollection sc : StandardCollection.values()) {
            this.writer.format("%n<%s>%n", sc.name());
            this.helpFormatter.printWrapped(this.writer, this.helpFormatter.getWidth(), this.helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + sc.desc());
            this.helpFormatter.printWrapped(this.writer, this.helpFormatter.getWidth(), this.helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + "File patterns: " + (sc.patterns().isEmpty() ? "<none>" : String.join((CharSequence)", ", sc.patterns())));
            this.helpFormatter.printWrapped(this.writer, this.helpFormatter.getWidth(), this.helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + "Provides a path matcher: " + sc.hasDocumentNameMatchSupplier());
            this.helpFormatter.printWrapped(this.writer, this.helpFormatter.getWidth(), this.helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + "Provides a file processor: " + sc.fileProcessor().hasNext());
        }
        this.writer.println("\nA path matcher will match specific information about the file.");
        this.writer.println("\nA file processor will process the associated \"ignore\" file for include and exclude directives");
        this.writer.println(Help.header("Notes"));
        int idx = 1;
        for (String note : NOTES) {
            this.writer.format("%d. %s%n", idx++, note);
        }
        this.writer.flush();
    }

    public String printArgumentTypes() {
        String argumentPadding = Help.createPadding(this.helpFormatter.getLeftPadding() + 4);
        for (Map.Entry<String, Supplier<String>> argInfo : OptionCollection.getArgumentTypes().entrySet()) {
            this.writer.format("%n<%s>%n", argInfo.getKey());
            this.helpFormatter.printWrapped(this.writer, this.helpFormatter.getWidth(), this.helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + argInfo.getValue().get());
        }
        return argumentPadding;
    }
}

