/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllFloatsSketchSerDeTest {
    @Test
    public void serializeDeserializeEmpty() {
        int N = 20;
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        byte[] bytes = sk1.toByteArray();
        KllFloatsSketch sk2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertTrue((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllFloatsSketch sk3 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])bytes));
        Assert.assertTrue((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk3.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        try {
            sk3.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk3.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }

    @Test
    public void serializeDeserializeOneValue() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance();
        sk1.update(1.0f);
        byte[] bytes = sk1.toByteArray();
        KllFloatsSketch sk2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertFalse((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sk2.getN(), (long)1L);
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)1.0f);
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)12);
        KllFloatsSketch sk3 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])bytes));
        Assert.assertFalse((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)1);
        Assert.assertEquals((long)sk3.getN(), (long)1L);
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((float)sk3.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk3.getMaxItem(), (float)1.0f);
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }

    @Test
    public void serializeDeserializeMultipleValues() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance();
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sk1.update((float)i);
        }
        Assert.assertEquals((float)sk1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sk1.getMaxItem(), (float)999.0f);
        byte[] bytes = sk1.toByteArray();
        KllFloatsSketch sk2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertFalse((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((float)sk2.getMinItem(), (float)sk1.getMinItem());
        Assert.assertEquals((float)sk2.getMaxItem(), (float)sk1.getMaxItem());
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllFloatsSketch sk3 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])bytes));
        Assert.assertFalse((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk3.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((float)sk3.getMinItem(), (float)sk1.getMinItem());
        Assert.assertEquals((float)sk3.getMaxItem(), (float)sk1.getMaxItem());
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }
}

