/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.hash.MurmurHash3FFM21;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MurmurHash3FFM21bTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkByteArrRemainderGT8() {
        String keyStr = "The quick brown fox jumps over the lazy dog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3FFM21.hash((byte[])key, (long)0L);
        long h1 = -2068352364225029268L;
        long h2 = 8809951995912426311L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrRemainderGT8withSegment() {
        String keyStr = "The quick brown fox jumps over the lazy dog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] out = new long[2];
        MemorySegment seg = MemorySegment.ofArray(key);
        long[] result = MurmurHash3FFM21.hash((MemorySegment)seg, (long)0L, (long)seg.byteSize(), (long)0L, (long[])out);
        long h1 = -2068352364225029268L;
        long h2 = 8809951995912426311L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrChange1bit() {
        String keyStr = "The quick brown fox jumps over the lazy eog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3FFM21.hash((byte[])key, (long)0L);
        long h1 = 3900407617836732873L;
        long h2 = 3640541342445253381L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrRemainderLt8() {
        String keyStr = "The quick brown fox jumps over the lazy dogdogdog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3FFM21.hash((byte[])key, (long)0L);
        long h1 = -7169161952862588988L;
        long h2 = -3764816456417919495L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrReaminderEQ8() {
        String keyStr = "The quick brown fox jumps over the lazy1";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3FFM21.hash((byte[])key, (long)0L);
        long h1 = -2076130280449712157L;
        long h2 = -4774090513620991086L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkLongArrRemainderEQ8() {
        String keyStr = "The quick brown fox jumps over the lazy1";
        long[] key = MurmurHash3FFM21bTest.stringToLongs(keyStr);
        long[] result = MurmurHash3FFM21.hash((long[])key, (long)0L);
        long h1 = -2076130280449712157L;
        long h2 = -4774090513620991086L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkIntArrRemainderEQ8() {
        String keyStr = "The quick brown fox jumps over the lazy1";
        int[] key = MurmurHash3FFM21bTest.stringToInts(keyStr);
        long[] result = MurmurHash3FFM21.hash((int[])key, (long)0L);
        long h1 = -2076130280449712157L;
        long h2 = -4774090513620991086L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkIntArrRemainderEQ0() {
        String keyStr = "The quick brown fox jumps over t";
        int[] key = MurmurHash3FFM21bTest.stringToInts(keyStr);
        long[] result = MurmurHash3FFM21.hash((int[])key, (long)0L);
        long h1 = -2347790358364300593L;
        long h2 = -7952440200260357210L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkIntArrOddRemainder() {
        String keyStr = "The quick brown fox jumps over the lazy dog";
        int[] key = MurmurHash3FFM21bTest.stringToInts(keyStr);
        long[] result = MurmurHash3FFM21.hash((int[])key, (long)0L);
        long h1 = 2211886098629870581L;
        long h2 = -266816821277170673L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkCharArrOddRemainder() {
        String keyStr = "The quick brown fox jumps over the lazy dog..";
        char[] key = keyStr.toCharArray();
        long[] result = MurmurHash3FFM21.hash((char[])key, (long)0L);
        long h1 = -3857415986955232941L;
        long h2 = -8390330609763588738L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkCharArrRemainderEQ0() {
        String keyStr = "The quick brown fox jumps over the lazy ";
        char[] key = keyStr.toCharArray();
        long[] result = MurmurHash3FFM21.hash((char[])key, (long)0L);
        long h1 = 5886590216495954417L;
        long h2 = -9149394530286104085L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrAllOnesZeros() {
        byte[] key = new byte[]{84, 104, 101, 32, 113, 117, 105, 99, 107, 32, 98, 114, 111, 119, 110, 32, 102, 111, 120, 32, 106, 117, 109, 112, 115, 32, 111, 118, 101, 114, 32, 116, 104, 101, 32, 108, 97, 122, 121, 32, 100, 111, 103, -1, 100, 111, 103, 0};
        long[] result = MurmurHash3FFM21.hash((byte[])key, (long)0L);
        long h1 = -1690330182926033762L;
        long h2 = -7585885279059409962L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkCrossTypeHashConsistency() {
        MurmurHash3FFM21bTest.println("Bytes");
        byte[] bArr = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
        long[] out1 = MurmurHash3FFM21.hash((byte[])bArr, (long)0L);
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out1[0]));
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out1[1]));
        MurmurHash3FFM21bTest.println("Chars");
        char[] cArr = new char[]{'\u0201', '\u0403', '\u0605', '\u0807', '\u0a09', '\u0c0b', '\u0e0d', '\u100f', '\u1211', '\u1413', '\u1615', '\u1817'};
        long[] out = MurmurHash3FFM21.hash((char[])cArr, (long)0L);
        Assert.assertEquals((long[])out, (long[])out1);
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out[0]));
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out[1]));
        MurmurHash3FFM21bTest.println("Ints");
        int[] iArr = new int[]{67305985, 134678021, 202050057, 269422093, 336794129, 404166165};
        out = MurmurHash3FFM21.hash((int[])iArr, (long)0L);
        Assert.assertEquals((long[])out, (long[])out1);
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out[0]));
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out[1]));
        MurmurHash3FFM21bTest.println("Longs");
        long[] lArr = new long[]{578437695752307201L, 1157159078456920585L, 1735880461161533969L};
        out = MurmurHash3FFM21.hash((long[])lArr, (long)0L);
        Assert.assertEquals((long[])out, (long[])out1);
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out[0]));
        MurmurHash3FFM21bTest.println(MurmurHash3FFM21bTest.longToHexBytes(out[1]));
    }

    @Test
    public void checkEmptyOrNullExceptions() {
        byte[] arr2;
        try {
            arr2 = null;
            MurmurHash3FFM21.hash(arr2, (long)1L);
            Assert.fail();
        }
        catch (IllegalArgumentException arr2) {
            // empty catch block
        }
        try {
            arr2 = null;
            MurmurHash3FFM21.hash(arr2, (long)1L);
            Assert.fail();
        }
        catch (IllegalArgumentException arr3) {
            // empty catch block
        }
        try {
            arr2 = null;
            MurmurHash3FFM21.hash(arr2, (long)1L);
            Assert.fail();
        }
        catch (IllegalArgumentException arr4) {
            // empty catch block
        }
        try {
            arr2 = null;
            MurmurHash3FFM21.hash(arr2, (long)1L);
            Assert.fail();
        }
        catch (IllegalArgumentException arr5) {
            // empty catch block
        }
        long[] out = new long[2];
        try {
            String in = null;
            MurmurHash3FFM21.hash(in, (long)1L, (long[])out);
            Assert.fail();
        }
        catch (IllegalArgumentException in) {
            // empty catch block
        }
        try {
            Memory mem = Memory.wrap((byte[])new byte[0]);
            MurmurHash3FFM21.hash((Memory)mem, (long)0L, (long)4L, (long)1L, (long[])out);
        }
        catch (IllegalArgumentException mem) {
            // empty catch block
        }
        try (Arena arena = Arena.ofConfined();){
            WritableMemory mem = WritableMemory.allocateDirect((long)8L, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            out = MurmurHash3FFM21.hash((Memory)mem, (long)0L, (long)4L, (long)1L, (long[])out);
        }
        Assert.assertTrue((out[0] != 0L && out[1] != 0L ? 1 : 0) != 0);
    }

    @Test
    public void checkHashTails() {
        long[] out = new long[2];
        WritableMemory mem = WritableMemory.allocate((int)32);
        mem.fill((byte)85);
        for (int i = 16; i <= 32; ++i) {
            out = MurmurHash3FFM21.hash((Memory)mem, (long)0L, (long)i, (long)1L, (long[])out);
        }
    }

    @Test
    public void checkSinglePrimitives() {
        long[] out = new long[2];
        out = MurmurHash3FFM21.hash((long)1L, (long)1L, (long[])out);
        out = MurmurHash3FFM21.hash((double)0.0, (long)1L, (long[])out);
        out = MurmurHash3FFM21.hash((String)"123", (long)1L, (long[])out);
    }

    private static long[] stringToLongs(String in) {
        byte[] bArr = in.getBytes(StandardCharsets.UTF_8);
        int inLen = bArr.length;
        int outLen = inLen / 8 + (inLen % 8 != 0 ? 1 : 0);
        long[] out = new long[outLen];
        for (int i = 0; i < outLen - 1; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                out[n] = out[n] | ((long)bArr[i * 8 + j] & 0xFFL) << j * 8;
            }
        }
        int inTail = 8 * (outLen - 1);
        int rem = inLen - inTail;
        for (int j = 0; j < rem; ++j) {
            int n = outLen - 1;
            out[n] = out[n] | ((long)bArr[inTail + j] & 0xFFL) << j * 8;
        }
        return out;
    }

    private static int[] stringToInts(String in) {
        byte[] bArr = in.getBytes(StandardCharsets.UTF_8);
        int inLen = bArr.length;
        int outLen = inLen / 4 + (inLen % 4 != 0 ? 1 : 0);
        int[] out = new int[outLen];
        for (int i = 0; i < outLen - 1; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = i;
                out[n] = (int)((long)out[n] | ((long)bArr[i * 4 + j] & 0xFFL) << j * 8);
            }
        }
        int inTail = 4 * (outLen - 1);
        int rem = inLen - inTail;
        for (int j = 0; j < rem; ++j) {
            int n = outLen - 1;
            out[n] = (int)((long)out[n] | ((long)bArr[inTail + j] & 0xFFL) << j * 8);
        }
        return out;
    }

    private static String longToHexBytes(long v) {
        long mask = 255L;
        StringBuilder sb = new StringBuilder();
        int i = 8;
        while (i-- > 0) {
            String s = Long.toHexString(v >>> i * 8 & 0xFFL);
            sb.append(MurmurHash3FFM21bTest.zeroPad(s, 2)).append(" ");
        }
        return sb.toString();
    }

    private static final String zeroPad(String s, int fieldLength) {
        return MurmurHash3FFM21bTest.characterPad(s, fieldLength, '0', false);
    }

    private static final String characterPad(String s, int fieldLength, char padChar, boolean postpend) {
        char[] chArr = s.toCharArray();
        int sLen = chArr.length;
        if (sLen < fieldLength) {
            char[] out = new char[fieldLength];
            int blanks = fieldLength - sLen;
            if (postpend) {
                int i;
                for (i = 0; i < sLen; ++i) {
                    out[i] = chArr[i];
                }
                for (i = sLen; i < fieldLength; ++i) {
                    out[i] = padChar;
                }
            } else {
                int i;
                for (i = 0; i < blanks; ++i) {
                    out[i] = padChar;
                }
                for (i = blanks; i < fieldLength; ++i) {
                    out[i] = chArr[i - blanks];
                }
            }
            return String.valueOf(out);
        }
        return s;
    }

    @Test
    public void printlnTest() {
        MurmurHash3FFM21bTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

