/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.common.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest {
    private static final String LS = System.getProperty("line.separator");
    private static boolean enablePrinting = true;

    @Test
    public void numTrailingOnes() {
        long mask = 1L;
        for (int i = 0; i <= 64; ++i) {
            long v = (mask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFFFFL;
            mask <<= 1;
            int numT1s = Util.numberOfTrailingOnes((long)v);
            int numL1s = Util.numberOfLeadingOnes((long)v);
            Assert.assertEquals((int)Long.numberOfTrailingZeros(v ^ 0xFFFFFFFFFFFFFFFFL), (int)numT1s);
            Assert.assertEquals((int)Long.numberOfLeadingZeros(v ^ 0xFFFFFFFFFFFFFFFFL), (int)numL1s);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBoundsTest() {
        Util.checkBounds((long)999L, (long)2L, (long)1000L);
    }

    @Test
    public void checkIsPowerOf2() {
        Assert.assertEquals((boolean)Util.isPowerOf2((long)0L), (boolean)false);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)1L), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)2L), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)4L), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)8L), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)0x4000000000000000L), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)3L), (boolean)false);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)5L), (boolean)false);
        Assert.assertEquals((boolean)Util.isPowerOf2((long)-1L), (boolean)false);
    }

    @Test
    public void checkCheckIfPowerOf2() {
        Util.checkIfPowerOf2((long)8L, (String)"Test 8");
        try {
            Util.checkIfPowerOf2((long)7L, (String)"Test 7");
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCeilingIntPowerOf2() {
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)Integer.MAX_VALUE), (int)0x40000000);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)0x40000000), (int)0x40000000);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)64), (int)64);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)65), (int)128);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)0), (int)1);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)-1), (int)1);
    }

    @Test
    public void checkCeilingLongPowerOf2() {
        Assert.assertEquals((long)Util.ceilingPowerOf2((long)Long.MAX_VALUE), (long)0x4000000000000000L);
        Assert.assertEquals((long)Util.ceilingPowerOf2((long)0x4000000000000000L), (long)0x4000000000000000L);
        Assert.assertEquals((long)Util.ceilingPowerOf2((long)64L), (long)64L);
        Assert.assertEquals((long)Util.ceilingPowerOf2((long)65L), (long)128L);
        Assert.assertEquals((long)Util.ceilingPowerOf2((long)0L), (long)1L);
        Assert.assertEquals((long)Util.ceilingPowerOf2((long)-1L), (long)1L);
    }

    @Test
    public void checkCeilingPowerOf2double() {
        Assert.assertEquals((double)Util.ceilingPowerBaseOfDouble((double)2.0, (double)2.147483647E9), (double)Math.pow(2.0, 31.0));
        Assert.assertEquals((double)Util.ceilingPowerBaseOfDouble((double)2.0, (double)1.073741824E9), (double)Math.pow(2.0, 30.0));
        Assert.assertEquals((double)Util.ceilingPowerBaseOfDouble((double)2.0, (double)64.0), (double)64.0);
        Assert.assertEquals((double)Util.ceilingPowerBaseOfDouble((double)2.0, (double)65.0), (double)128.0);
        Assert.assertEquals((double)Util.ceilingPowerBaseOfDouble((double)2.0, (double)0.0), (double)1.0);
        Assert.assertEquals((double)Util.ceilingPowerBaseOfDouble((double)2.0, (double)-1.0), (double)1.0);
    }

    @Test
    public void checkFloorPowerOf2Int() {
        Assert.assertEquals((int)Util.floorPowerOf2((int)-1), (int)1);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0), (int)1);
        Assert.assertEquals((int)Util.floorPowerOf2((int)1), (int)1);
        Assert.assertEquals((int)Util.floorPowerOf2((int)2), (int)2);
        Assert.assertEquals((int)Util.floorPowerOf2((int)3), (int)2);
        Assert.assertEquals((int)Util.floorPowerOf2((int)4), (int)4);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0x3FFFFFFF), (int)0x20000000);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0x40000000), (int)0x40000000);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0x40000001), (int)0x40000000);
    }

    @Test
    public void checkFloorPowerOf2Long() {
        Assert.assertEquals((long)Util.floorPowerOf2((long)-1L), (long)1L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)0L), (long)1L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)1L), (long)1L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)2L), (long)2L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)3L), (long)2L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)4L), (long)4L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)Long.MAX_VALUE), (long)0x4000000000000000L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)0x4000000000000000L), (long)0x4000000000000000L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)0x4000000000000001L), (long)0x4000000000000000L);
    }

    @Test
    public void checkFloorPowerOf2double() {
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)-1.0), (double)1.0);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)0.0), (double)1.0);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)1.0), (double)1.0);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)2.0), (double)2.0);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)3.0), (double)2.0);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)4.0), (double)4.0);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)1.073741823E9), (double)5.36870912E8);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)1.073741824E9), (double)1.073741824E9);
        Assert.assertEquals((double)Util.floorPowerBaseOfDouble((double)2.0, (double)1.073741825E9), (double)1.073741824E9);
    }

    @Test
    public void checkCheckIfMultipleOf8AndGT0() {
        Util.checkIfMultipleOf8AndGT0((long)8L, (String)"test 8");
        try {
            Util.checkIfMultipleOf8AndGT0((long)7L, (String)"test 7");
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            Util.checkIfMultipleOf8AndGT0((long)-8L, (String)"test -8");
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            Util.checkIfMultipleOf8AndGT0((long)-1L, (String)"test -1");
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsMultipleOf8AndGT0() {
        Assert.assertTrue((boolean)Util.isMultipleOf8AndGT0((long)8L));
        Assert.assertFalse((boolean)Util.isMultipleOf8AndGT0((long)7L));
        Assert.assertFalse((boolean)Util.isMultipleOf8AndGT0((long)-8L));
        Assert.assertFalse((boolean)Util.isMultipleOf8AndGT0((long)-1L));
    }

    @Test
    public void checkInvPow2() {
        Assert.assertEquals((double)Util.invPow2((int)1), (double)0.5);
        Assert.assertEquals((double)Util.invPow2((int)0), (double)1.0);
        try {
            Util.invPow2((int)-1);
            UtilTest.failIAE();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            Util.invPow2((int)1024);
            UtilTest.failIAE();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            Util.invPow2((int)Integer.MIN_VALUE);
            UtilTest.failIAE();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private static void failIAE() {
        throw new IllegalArgumentException("Test should have failed!");
    }

    @Test
    public void checkIsLessThanUnsigned() {
        long n1 = 1L;
        long n2 = 3L;
        long n3 = -3L;
        long n4 = -1L;
        Assert.assertTrue((boolean)Util.isLessThanUnsigned((long)1L, (long)3L));
        Assert.assertTrue((boolean)Util.isLessThanUnsigned((long)3L, (long)-3L));
        Assert.assertTrue((boolean)Util.isLessThanUnsigned((long)-3L, (long)-1L));
        Assert.assertFalse((boolean)Util.isLessThanUnsigned((long)3L, (long)1L));
        Assert.assertFalse((boolean)Util.isLessThanUnsigned((long)-3L, (long)3L));
        Assert.assertFalse((boolean)Util.isLessThanUnsigned((long)-1L, (long)-3L));
    }

    @Test
    public void checkZeroPad() {
        long v = 123456789L;
        String vHex = Long.toHexString(123456789L);
        String out = Util.zeroPad((String)vHex, (int)16);
        UtilTest.println("Pad 16, prepend 0: " + out);
    }

    @Test
    public void checkCharacterPad() {
        String s = "Pad 30, postpend z:";
        String out = Util.characterPad((String)s, (int)30, (char)'z', (boolean)true);
        UtilTest.println(out);
        Assert.assertEquals((String)out, (String)"Pad 30, postpend z:zzzzzzzzzzz");
        s = "Pad 30, prepend z:";
        out = Util.characterPad((String)s, (int)30, (char)'z', (boolean)false);
        UtilTest.println(out);
        Assert.assertEquals((String)out, (String)"zzzzzzzzzzzzPad 30, prepend z:");
    }

    @Test
    public void checkProbabilityFn1() {
        Util.checkProbability((double)0.5, (String)"Good");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkProbabilityFn2() {
        Util.checkProbability((double)-0.5, (String)"Too Low");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkProbabilityFn3() {
        Util.checkProbability((double)1.5, (String)"Too High");
    }

    @Test
    public void checkEvenOdd() {
        Assert.assertTrue((boolean)Util.isEven((long)0L));
        Assert.assertFalse((boolean)Util.isOdd((long)0L));
        Assert.assertTrue((boolean)Util.isOdd((long)-1L));
        Assert.assertFalse((boolean)Util.isEven((long)-1L));
    }

    @Test
    public void checkBytesToInt() {
        byte[] arr = new byte[]{4, 3, 2, 1};
        int result = 16909060;
        Assert.assertEquals((int)Util.bytesToInt((byte[])arr), (int)16909060);
        byte[] arr2 = Util.intToBytes((int)16909060, (byte[])new byte[4]);
        Assert.assertEquals((byte[])arr, (byte[])arr2);
    }

    @Test
    public void checkBytesToLong() {
        byte[] arr = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        long result = 72623859790382856L;
        Assert.assertEquals((long)Util.bytesToLong((byte[])arr), (long)72623859790382856L);
    }

    @Test
    public void checkBytesToString() {
        long lng = -506664900861165055L;
        byte[] bytes = new byte[8];
        bytes = Util.longToBytes((long)-506664900861165055L, (byte[])bytes);
        String sep = ".";
        String unsignLE = Util.bytesToString((byte[])bytes, (boolean)false, (boolean)true, (String)".");
        String signedLE = Util.bytesToString((byte[])bytes, (boolean)true, (boolean)true, (String)".");
        String unsignBE = Util.bytesToString((byte[])bytes, (boolean)false, (boolean)false, (String)".");
        String signedBE = Util.bytesToString((byte[])bytes, (boolean)true, (boolean)false, (String)".");
        Assert.assertEquals((String)unsignLE, (String)"1.2.3.4.245.246.247.248");
        Assert.assertEquals((String)signedLE, (String)"1.2.3.4.-11.-10.-9.-8");
        Assert.assertEquals((String)unsignBE, (String)"248.247.246.245.4.3.2.1");
        Assert.assertEquals((String)signedBE, (String)"-8.-9.-10.-11.4.3.2.1");
    }

    @Test
    public void checkNsecToString() {
        long nS = 1001001001L;
        String result = Util.nanoSecToString((long)1001001001L);
        String expected = "1.001_001_001";
        Assert.assertEquals((String)result, (String)"1.001_001_001");
    }

    @Test
    public void checkMsecToString() {
        long nS = 3661001L;
        String result = Util.milliSecToString((long)3661001L);
        String expected = "1:01:01.001";
        Assert.assertEquals((String)result, (String)"1:01:01.001");
    }

    @Test
    public void checkPwr2LawNext() {
        int next = (int)Util.pwr2SeriesNext((int)2, (long)1L);
        Assert.assertEquals((int)next, (int)2);
        next = (int)Util.pwr2SeriesNext((int)2, (long)2L);
        Assert.assertEquals((int)next, (int)3);
        next = (int)Util.pwr2SeriesNext((int)2, (long)3L);
        Assert.assertEquals((int)next, (int)4);
        next = (int)Util.pwr2SeriesNext((int)2, (long)0L);
        Assert.assertEquals((int)next, (int)1);
    }

    @Test
    public void checkPwr2LawNextDouble() {
        double next = Util.powerSeriesNextDouble((int)2, (double)1.0, (boolean)true, (double)2.0);
        Assert.assertEquals((double)next, (double)2.0, (double)0.0);
        next = Util.powerSeriesNextDouble((int)2, (double)2.0, (boolean)true, (double)2.0);
        Assert.assertEquals((double)next, (double)3.0, (double)0.0);
        next = Util.powerSeriesNextDouble((int)2, (double)3.0, (boolean)true, (double)2.0);
        Assert.assertEquals((double)next, (double)4.0, (double)0.0);
        next = Util.powerSeriesNextDouble((int)2, (double)1.0, (boolean)false, (double)2.0);
        Assert.assertEquals((double)next, (double)Math.sqrt(2.0), (double)0.0);
        next = Util.powerSeriesNextDouble((int)2, (double)0.5, (boolean)true, (double)2.0);
        Assert.assertEquals((double)next, (double)2.0, (double)0.0);
        next = Util.powerSeriesNextDouble((int)2, (double)0.5, (boolean)false, (double)2.0);
        Assert.assertEquals((double)next, (double)Math.sqrt(2.0), (double)0.0);
        next = Util.powerSeriesNextDouble((int)2, (double)next, (boolean)false, (double)2.0);
        Assert.assertEquals((double)next, (double)2.0, (double)0.0);
    }

    @Test
    public void checkPwr2SeriesExamples() {
        int maxP = 32;
        boolean minP = true;
        int ppo = 4;
        int p = 1;
        while (p <= 32) {
            UtilTest.print(p + " ");
            p = (int)Util.pwr2SeriesNext((int)4, (long)p);
        }
        UtilTest.println("");
        p = 32;
        while (p >= 1) {
            UtilTest.print(p + " ");
            p = Util.pwr2SeriesPrev((int)4, (int)p);
        }
        UtilTest.println("");
    }

    @Test
    public void checkExactLog2OfLong() {
        Assert.assertEquals((int)Util.exactLog2OfLong((long)2L), (int)1);
        Assert.assertEquals((int)Util.exactLog2OfLong((long)1L), (int)0);
        Assert.assertEquals((int)Util.exactLog2OfLong((long)0x4000000000000000L), (int)62);
        try {
            Util.exactLog2OfLong((long)0L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExactLog2OfInt() {
        Assert.assertEquals((int)Util.exactLog2OfInt((int)2), (int)1);
        Assert.assertEquals((int)Util.exactLog2OfInt((int)1), (int)0);
        Assert.assertEquals((int)Util.exactLog2OfInt((int)0x40000000), (int)30);
        try {
            Util.exactLog2OfInt((int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExactLog2OfLongWithArg() {
        Assert.assertEquals((int)Util.exactLog2OfLong((long)2L, (String)"2"), (int)1);
        Assert.assertEquals((int)Util.exactLog2OfLong((long)1L, (String)"1"), (int)0);
        Assert.assertEquals((int)Util.exactLog2OfLong((long)0x4000000000000000L, (String)"1L<<62"), (int)62);
        try {
            Util.exactLog2OfLong((long)0L, (String)"0");
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExactLog2OfIntWithArg() {
        Assert.assertEquals((int)Util.exactLog2OfInt((int)2, (String)"2"), (int)1);
        Assert.assertEquals((int)Util.exactLog2OfInt((int)1, (String)"1"), (int)0);
        Assert.assertEquals((int)Util.exactLog2OfInt((int)0x40000000, (String)"1<<30"), (int)30);
        try {
            Util.exactLog2OfInt((int)0, (String)"0");
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    static void checkConvertToLongArray() {
        byte[] arr = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        long[] out = Util.convertToLongArray((byte[])arr, (boolean)false);
        String s = Util.zeroPad((String)Long.toHexString(out[0]), (int)16);
        Assert.assertEquals((String)s, (String)"0807060504030201");
        s = Util.zeroPad((String)Long.toHexString(out[1]), (int)16);
        Assert.assertEquals((String)s, (String)"000000000c0b0a09");
        out = Util.convertToLongArray((byte[])arr, (boolean)true);
        s = Util.zeroPad((String)Long.toHexString(out[0]), (int)16);
        Assert.assertEquals((String)s, (String)"0102030405060708");
        s = Util.zeroPad((String)Long.toHexString(out[1]), (int)16);
        Assert.assertEquals((String)s, (String)"00000000090a0b0c");
    }

    @Test
    static void checkCeilingMultiple2expK() {
        long n = 15L;
        int k = 6;
        long v = Util.ceilingMultiple2expK((long)15L, (int)6);
        long v2 = (long)Math.ceil(0.234375);
        Assert.assertEquals((long)v, (long)v2);
    }

    @Test
    public void checkDirCreation() {
        Assert.assertNotNull((Object)TestUtil.javaPath);
        Assert.assertNotNull((Object)TestUtil.cppPath);
    }

    @Test
    public void printlnTest() {
        UtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (enablePrinting) {
            if (o == null) {
                UtilTest.print(LS);
            } else {
                UtilTest.print(o.toString() + LS);
            }
        }
    }

    static void print(Object o) {
        if (!enablePrinting || o != null) {
            // empty if block
        }
    }
}

