/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitLessOrEqualFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitLessOrEqualFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitLessOrEqualFilter() {
        super("Initialize Less Or Equal filter");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(container.getTlvId(), 2);
        searchRequestDecorator.addCurrentFilter(filter);
        searchRequestDecorator.setTerminalFilter(filter);
        if (IS_DEBUG) {
            LOG.debug("Initialize Less Or Equal filter");
        }
    }
}

