/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.Constants;
import org.apache.felix.deploymentadmin.ContentCopyingJarInputStream;
import org.apache.felix.deploymentadmin.DeploymentAdminConfig;
import org.apache.felix.deploymentadmin.FileDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.Semaphore;
import org.apache.felix.deploymentadmin.StreamDeploymentPackage;
import org.apache.felix.deploymentadmin.Utils;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.DropAllBundlesCommand;
import org.apache.felix.deploymentadmin.spi.DropAllResourcesCommand;
import org.apache.felix.deploymentadmin.spi.DropBundleCommand;
import org.apache.felix.deploymentadmin.spi.DropResourceCommand;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.apache.felix.deploymentadmin.spi.ProcessResourceCommand;
import org.apache.felix.deploymentadmin.spi.SnapshotCommand;
import org.apache.felix.deploymentadmin.spi.StartBundleCommand;
import org.apache.felix.deploymentadmin.spi.StartCustomizerCommand;
import org.apache.felix.deploymentadmin.spi.StopBundleCommand;
import org.apache.felix.deploymentadmin.spi.UpdateCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DeploymentAdminImpl
implements DeploymentAdmin,
Constants {
    public static final String PACKAGE_DIR = "packages";
    public static final String TEMP_DIR = "temp";
    public static final String PACKAGECONTENTS_DIR = "contents";
    public static final String PACKAGEINDEX_FILE = "index.txt";
    public static final String TEMP_PREFIX = "pkg";
    public static final String TEMP_POSTFIX = "";
    private static final long TIMEOUT = 10000L;
    private volatile BundleContext m_context;
    private volatile PackageAdmin m_packageAdmin;
    private volatile EventAdmin m_eventAdmin;
    private volatile LogService m_log;
    private volatile DeploymentSessionImpl m_session;
    private final Map m_packages = new HashMap();
    private final Semaphore m_semaphore = new Semaphore();

    public DeploymentAdminImpl() {
    }

    DeploymentAdminImpl(BundleContext context) {
        this.m_context = context;
    }

    public boolean cancel() {
        DeploymentSessionImpl session = this.m_session;
        if (session != null) {
            session.cancel();
            return true;
        }
        return false;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public DeploymentPackage getDeploymentPackage(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle can not be null");
        }
        return this.getDeploymentPackageContainingBundleWithSymbolicName(bundle.getSymbolicName());
    }

    public DeploymentPackage getDeploymentPackage(String symbName) {
        if (symbName == null) {
            throw new IllegalArgumentException("Symbolic name may not be null");
        }
        return (DeploymentPackage)this.m_packages.get(symbName);
    }

    public LogService getLog() {
        return this.m_log;
    }

    public PackageAdmin getPackageAdmin() {
        return this.m_packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentPackage installDeploymentPackage(InputStream sourceInput) throws DeploymentException {
        FileDeploymentPackage fileDeploymentPackage;
        if (sourceInput == null) {
            throw new IllegalArgumentException("Inputstream may not be null");
        }
        try {
            if (!this.m_semaphore.tryAcquire(10000L)) {
                throw new DeploymentException(465, "Timeout exceeded while waiting to install deployment package (10000 ms)");
            }
        }
        catch (InterruptedException ie) {
            throw new DeploymentException(465, "Thread interrupted");
        }
        File tempPackage = null;
        StreamDeploymentPackage source = null;
        AbstractDeploymentPackage target = null;
        boolean succeeded = false;
        try {
            ContentCopyingJarInputStream jarInput = null;
            File tempIndex = null;
            File tempContents = null;
            try {
                File tempDir = this.m_context.getDataFile(TEMP_DIR);
                tempDir.mkdirs();
                tempPackage = File.createTempFile(TEMP_PREFIX, TEMP_POSTFIX, tempDir);
                tempPackage.delete();
                tempPackage.mkdirs();
                tempIndex = new File(tempPackage, PACKAGEINDEX_FILE);
                tempContents = new File(tempPackage, PACKAGECONTENTS_DIR);
                tempContents.mkdirs();
            }
            catch (IOException e) {
                this.m_log.log(1, "Error writing package to disk", (Throwable)e);
                throw new DeploymentException(463, "Error writing package to disk", e);
            }
            try {
                jarInput = new ContentCopyingJarInputStream(sourceInput, tempIndex, tempContents);
                if (jarInput.getManifest() == null) {
                    Utils.closeSilently(jarInput);
                    this.m_log.log(1, "Stream does not contain a valid deployment package: missing manifest!");
                    throw new DeploymentException(451, "No manifest present in deployment package!");
                }
            }
            catch (IOException e) {
                this.m_log.log(1, "Stream does not contain a valid Jar", (Throwable)e);
                throw new DeploymentException(404, "Stream does not contain a valid Jar", e);
            }
            source = new StreamDeploymentPackage(jarInput, this.m_context, this);
            String dpSymbolicName = source.getName();
            target = this.getExistingOrEmptyDeploymentPackage(dpSymbolicName);
            this.sendStartedEvent(source, target);
            this.verifyNoResourcesShared(source, target);
            if (source.isFixPackage()) {
                this.verifyFixPackage(source, target);
            } else {
                this.verifySourcePackage(source);
            }
            try {
                this.m_session = new DeploymentSessionImpl(source, target, this.createInstallCommandChain(), this, new DeploymentAdminConfig(this.m_context));
                this.m_session.call(false);
            }
            catch (DeploymentException de) {
                throw de;
            }
            finally {
                Utils.closeSilently(jarInput);
            }
            String dpInstallBaseDirectory = PACKAGE_DIR + File.separator + dpSymbolicName;
            File targetContents = this.m_context.getDataFile(dpInstallBaseDirectory + File.separator + PACKAGECONTENTS_DIR);
            File targetIndex = this.m_context.getDataFile(dpInstallBaseDirectory + File.separator + PACKAGEINDEX_FILE);
            if (source.isFixPackage()) {
                try {
                    Utils.merge(targetIndex, targetContents, tempIndex, tempContents);
                }
                catch (IOException e) {
                    this.m_log.log(1, "Could not merge source fix package with target deployment package", (Throwable)e);
                    throw new DeploymentException(463, "Could not merge source fix package with target deployment package", e);
                }
            } else {
                File targetPackage = this.m_context.getDataFile(dpInstallBaseDirectory);
                targetPackage.mkdirs();
                if (!Utils.replace(targetPackage, tempPackage)) {
                    throw new DeploymentException(463, "Could not replace " + targetPackage + " with " + tempPackage);
                }
            }
            FileDeploymentPackage fileDeploymentPackage2 = null;
            try {
                fileDeploymentPackage2 = new FileDeploymentPackage(targetIndex, targetContents, this.m_context, this);
                this.m_packages.put(dpSymbolicName, fileDeploymentPackage2);
            }
            catch (IOException e) {
                this.m_log.log(1, "Could not create installed deployment package from disk", (Throwable)e);
                throw new DeploymentException(463, "Could not create installed deployment package from disk", e);
            }
            succeeded = true;
            fileDeploymentPackage = fileDeploymentPackage2;
        }
        catch (Throwable throwable) {
            if (tempPackage != null && !Utils.delete(tempPackage, true)) {
                this.m_log.log(1, "Could not delete temporary deployment package from disk");
                succeeded = false;
            }
            this.sendCompleteEvent(source, target, succeeded);
            this.m_semaphore.release();
            throw throwable;
        }
        if (tempPackage != null && !Utils.delete(tempPackage, true)) {
            this.m_log.log(1, "Could not delete temporary deployment package from disk");
            succeeded = false;
        }
        this.sendCompleteEvent(source, target, succeeded);
        this.m_semaphore.release();
        return fileDeploymentPackage;
    }

    public DeploymentPackage[] listDeploymentPackages() {
        Collection packages = this.m_packages.values();
        return packages.toArray(new DeploymentPackage[packages.size()]);
    }

    public void start() throws DeploymentException {
        File packageDir = this.m_context.getDataFile(PACKAGE_DIR);
        if (packageDir == null) {
            throw new DeploymentException(463, "Could not create directories needed for deployment package persistence");
        }
        if (packageDir.isDirectory()) {
            File[] dpPackages = packageDir.listFiles();
            for (int i = 0; i < dpPackages.length; ++i) {
                File dpPackageDir = dpPackages[i];
                if (!dpPackageDir.isDirectory()) continue;
                try {
                    File index = new File(dpPackageDir, PACKAGEINDEX_FILE);
                    File contents = new File(dpPackageDir, PACKAGECONTENTS_DIR);
                    FileDeploymentPackage dp = new FileDeploymentPackage(index, contents, this.m_context, this);
                    this.m_packages.put(dp.getName(), dp);
                    continue;
                }
                catch (IOException e) {
                    this.m_log.log(2, "Could not read deployment package from disk, skipping: '" + dpPackageDir.getAbsolutePath() + "'");
                }
            }
        }
    }

    public void stop() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallDeploymentPackage(DeploymentPackage dp, boolean forced) throws DeploymentException {
        try {
            if (!this.m_semaphore.tryAcquire(10000L)) {
                throw new DeploymentException(465, "Timeout exceeded while waiting to uninstall deployment package (10000 ms)");
            }
        }
        catch (InterruptedException ie) {
            throw new DeploymentException(465, "Thread interrupted");
        }
        boolean succeeded = false;
        AbstractDeploymentPackage source = AbstractDeploymentPackage.EMPTY_PACKAGE;
        AbstractDeploymentPackage target = (AbstractDeploymentPackage)dp;
        this.sendUninstallEvent(source, target);
        try {
            this.m_session = new DeploymentSessionImpl(source, target, this.createUninstallCommandChain(), this, new DeploymentAdminConfig(this.m_context));
            this.m_session.call(forced);
            File targetPackage = this.m_context.getDataFile(PACKAGE_DIR + File.separator + source.getName());
            if (!Utils.delete(targetPackage, true)) {
                this.m_log.log(1, "Could not delete deployment package from disk");
                throw new DeploymentException(463, "Could not delete deployment package from disk");
            }
            this.m_packages.remove(dp.getName());
            succeeded = true;
        }
        finally {
            this.sendCompleteEvent(source, target, succeeded);
            this.m_semaphore.release();
        }
    }

    private Dictionary createEventProperties(AbstractDeploymentPackage source, AbstractDeploymentPackage target) {
        Properties props = new Properties();
        if (source != null) {
            String displayName = source.getDisplayName();
            if (displayName == null) {
                displayName = source.getName();
            }
            ((Dictionary)props).put("deploymentpackage.name", source.getName());
            ((Dictionary)props).put("deploymentpackage.readablename", displayName);
            if (!source.isNew()) {
                ((Dictionary)props).put("deploymentpackage.nextversion", source.getVersion());
            }
        }
        if (target != null && !target.isNew()) {
            ((Dictionary)props).put("deploymentpackage.currentversion", target.getVersion());
        }
        return props;
    }

    private List createInstallCommandChain() {
        ArrayList<Command> commandChain = new ArrayList<Command>();
        GetStorageAreaCommand getStorageAreaCommand = new GetStorageAreaCommand();
        commandChain.add(getStorageAreaCommand);
        commandChain.add(new StopBundleCommand());
        commandChain.add(new SnapshotCommand(getStorageAreaCommand));
        commandChain.add(new UpdateCommand());
        commandChain.add(new StartCustomizerCommand());
        CommitResourceCommand commitCommand = new CommitResourceCommand();
        commandChain.add(new ProcessResourceCommand(commitCommand));
        commandChain.add(new DropResourceCommand(commitCommand));
        commandChain.add(new DropBundleCommand());
        commandChain.add(commitCommand);
        commandChain.add(new StartBundleCommand());
        return commandChain;
    }

    private List createUninstallCommandChain() {
        ArrayList<Command> commandChain = new ArrayList<Command>();
        GetStorageAreaCommand getStorageAreaCommand = new GetStorageAreaCommand();
        commandChain.add(getStorageAreaCommand);
        commandChain.add(new StopBundleCommand());
        commandChain.add(new SnapshotCommand(getStorageAreaCommand));
        commandChain.add(new StartCustomizerCommand());
        CommitResourceCommand commitCommand = new CommitResourceCommand();
        commandChain.add(new DropAllResourcesCommand(commitCommand));
        commandChain.add(commitCommand);
        commandChain.add(new DropAllBundlesCommand());
        return commandChain;
    }

    private AbstractDeploymentPackage getDeploymentPackageContainingBundleWithSymbolicName(String symbolicName) {
        for (AbstractDeploymentPackage dp : this.m_packages.values()) {
            if (dp.getBundle(symbolicName) == null) continue;
            return dp;
        }
        return null;
    }

    private AbstractDeploymentPackage getExistingOrEmptyDeploymentPackage(String symbolicName) {
        AbstractDeploymentPackage result = (AbstractDeploymentPackage)this.m_packages.get(symbolicName);
        if (result == null) {
            result = AbstractDeploymentPackage.EMPTY_PACKAGE;
        }
        return result;
    }

    private Bundle[] getNonDeploymentPackagedBundles() {
        ArrayList<Bundle> result = new ArrayList<Bundle>(Arrays.asList(this.m_context.getBundles()));
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Bundle suspect = (Bundle)iter.next();
            if (!suspect.getLocation().startsWith("osgi-dp:")) continue;
            iter.remove();
        }
        return result.toArray(new Bundle[result.size()]);
    }

    private void sendCompleteEvent(AbstractDeploymentPackage source, AbstractDeploymentPackage target, boolean success) {
        Dictionary props = this.createEventProperties(source, target);
        props.put("successful", success);
        this.m_eventAdmin.postEvent(new Event("org/osgi/service/deployment/COMPLETE", props));
    }

    private void sendStartedEvent(AbstractDeploymentPackage source, AbstractDeploymentPackage target) {
        Dictionary props = this.createEventProperties(source, target);
        this.m_eventAdmin.postEvent(new Event("org/osgi/service/deployment/INSTALL", props));
    }

    private void sendUninstallEvent(AbstractDeploymentPackage source, AbstractDeploymentPackage target) {
        Dictionary props = this.createEventProperties(source, target);
        this.m_eventAdmin.postEvent(new Event("org/osgi/service/deployment/UNINSTALL", props));
    }

    private void verifyFixPackage(AbstractDeploymentPackage source, AbstractDeploymentPackage target) throws DeploymentException {
        boolean newPackage = target.isNew();
        if (newPackage || !source.getVersionRange().isInRange(target.getVersion())) {
            this.m_log.log(1, "Target package version '" + target.getVersion() + "' is not in source range '" + source.getVersionRange() + "'");
            throw new DeploymentException(453, "Target package version '" + target.getVersion() + "' is not in source range '" + source.getVersionRange() + "'");
        }
        BundleInfoImpl[] bundleInfos = source.getBundleInfoImpls();
        for (int i = 0; i < bundleInfos.length; ++i) {
            BundleInfoImpl targetBundleInfo;
            if (!bundleInfos[i].isMissing() || (targetBundleInfo = target.getBundleInfoByPath(bundleInfos[i].getPath())) != null) continue;
            this.m_log.log(1, "Missing bundle '" + bundleInfos[i].getSymbolicName() + "/" + bundleInfos[i].getVersion() + " does not exist in target package!");
            throw new DeploymentException(454, "Missing bundle '" + bundleInfos[i].getSymbolicName() + "/" + bundleInfos[i].getVersion() + " does not exist in target package!");
        }
        ResourceInfoImpl[] resourceInfos = source.getResourceInfos();
        for (int i = 0; i < resourceInfos.length; ++i) {
            ResourceInfoImpl targetResourceInfo;
            if (!resourceInfos[i].isMissing() || (targetResourceInfo = target.getResourceInfoByPath(resourceInfos[i].getPath())) != null) continue;
            this.m_log.log(1, "Missing resource '" + resourceInfos[i].getPath() + " does not exist in target package!");
            throw new DeploymentException(455, "Missing resource '" + resourceInfos[i].getPath() + " does not exist in target package!");
        }
    }

    private void verifyNoResourcesShared(AbstractDeploymentPackage source, AbstractDeploymentPackage target) throws DeploymentException {
        Bundle[] foreignBundles = this.getNonDeploymentPackagedBundles();
        BundleInfoImpl[] bundleInfos = source.getBundleInfoImpls();
        for (int i = 0; i < bundleInfos.length; ++i) {
            String symbolicName = bundleInfos[i].getSymbolicName();
            Version version = bundleInfos[i].getVersion();
            AbstractDeploymentPackage targetPackage = this.getDeploymentPackageContainingBundleWithSymbolicName(symbolicName);
            if (targetPackage != null && !targetPackage.equals(target)) {
                this.m_log.log(1, "Bundle '" + symbolicName + "/" + version + " already present in other deployment packages!");
                throw new DeploymentException(460, "Bundle '" + symbolicName + "/" + version + " already present in other deployment packages!");
            }
            if (targetPackage != null) continue;
            for (int j = 0; j < foreignBundles.length; ++j) {
                if (!symbolicName.equals(foreignBundles[j].getSymbolicName()) || !version.equals((Object)foreignBundles[j].getVersion())) continue;
                this.m_log.log(1, "Bundle '" + symbolicName + "/" + version + " already present!");
                throw new DeploymentException(460, "Bundle '" + symbolicName + "/" + version + " already present!");
            }
        }
    }

    private void verifySourcePackage(AbstractDeploymentPackage source) throws DeploymentException {
    }
}

