/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.i18n;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

class CombinedEnumeration
implements Enumeration<String> {
    private final Enumeration<String> first;
    private final Enumeration<String> second;
    private final Set<String> seenKeys;
    private String nextKey;

    CombinedEnumeration(Enumeration<String> first, Enumeration<String> second) {
        this.first = first;
        this.second = second;
        this.seenKeys = new HashSet<String>();
        this.nextKey = this.seek();
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextKey != null;
    }

    @Override
    public String nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        String result = this.nextKey;
        this.nextKey = this.seek();
        return result;
    }

    private String seek() {
        String next;
        while (this.first.hasMoreElements()) {
            next = this.first.nextElement();
            if (this.seenKeys.contains(next)) continue;
            this.seenKeys.add(next);
            return next;
        }
        while (this.second.hasMoreElements()) {
            next = this.second.nextElement();
            if (this.seenKeys.contains(next)) continue;
            this.seenKeys.add(next);
            return next;
        }
        return null;
    }
}

