/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import com.microsoft.azure.cosmosdb.Error;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DocumentClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Error error;
    private final int statusCode;
    private final Map<String, String> responseHeaders;
    private ClientSideRequestStatistics clientSideRequestStatistics;
    String resourceAddress;
    String partitionKeyRangeId;
    URI requestUri;
    long lsn;
    Map<String, String> requestHeaders;

    public DocumentClientException(int statusCode) {
        this.statusCode = statusCode;
        this.responseHeaders = new HashMap<String, String>();
    }

    public DocumentClientException(int statusCode, String errorMessage) {
        Error error = new Error();
        error.set("message", errorMessage);
        this.statusCode = statusCode;
        this.error = error;
        this.responseHeaders = new HashMap<String, String>();
    }

    public DocumentClientException(int statusCode, Exception innerException) {
        super(innerException);
        this.statusCode = statusCode;
        this.responseHeaders = new HashMap<String, String>();
    }

    public DocumentClientException(int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        this(null, statusCode, errorResource, responseHeaders);
    }

    public DocumentClientException(String resourceAddress, int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        super(errorResource == null ? null : errorResource.getMessage());
        this.responseHeaders = this.safeResponseHeaders(responseHeaders);
        this.resourceAddress = resourceAddress;
        this.statusCode = statusCode;
        this.error = errorResource;
    }

    public DocumentClientException(String message, Exception exception, Map<String, String> responseHeaders, int statusCode, String resourceAddress) {
        super(message, exception);
        this.responseHeaders = this.safeResponseHeaders(responseHeaders);
        this.resourceAddress = resourceAddress;
        this.statusCode = statusCode;
    }

    @Override
    public String getMessage() {
        if (this.clientSideRequestStatistics == null) {
            return this.getInnerErrorMessage();
        }
        return this.getInnerErrorMessage() + ", " + this.clientSideRequestStatistics.toString();
    }

    public String getActivityId() {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        String subStatusString;
        int code = 0;
        if (this.responseHeaders != null && StringUtils.isNotEmpty((CharSequence)(subStatusString = this.responseHeaders.get("x-ms-substatus")))) {
            try {
                code = Integer.parseInt(subStatusString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return code;
    }

    public Error getError() {
        return this.error;
    }

    public long getRetryAfterInMilliseconds() {
        String header;
        long retryIntervalInMilliseconds = 0L;
        if (this.responseHeaders != null && StringUtils.isNotEmpty((CharSequence)(header = this.responseHeaders.get("x-ms-retry-after-ms")))) {
            try {
                retryIntervalInMilliseconds = Long.parseLong(header);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryIntervalInMilliseconds;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    String getResourceAddress() {
        return this.resourceAddress;
    }

    public ClientSideRequestStatistics getClientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    public void setClientSideRequestStatistics(ClientSideRequestStatistics clientSideRequestStatistics) {
        this.clientSideRequestStatistics = clientSideRequestStatistics;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{error=" + this.error + ", resourceAddress='" + this.resourceAddress + '\'' + ", statusCode=" + this.statusCode + ", message=" + this.getMessage() + ", getCauseInfo=" + this.getCauseInfo() + ", responseHeaders=" + this.responseHeaders + ", requestHeaders=" + this.requestHeaders + '}';
    }

    String getInnerErrorMessage() {
        String innerErrorMessage = super.getMessage();
        if (this.error != null && (innerErrorMessage = this.error.getMessage()) == null) {
            innerErrorMessage = String.valueOf(this.error.get("Errors"));
        }
        return innerErrorMessage;
    }

    private String getCauseInfo() {
        Throwable cause = this.getCause();
        if (cause != null) {
            return String.format("[class: %s, message: %s]", cause.getClass(), cause.getMessage());
        }
        return null;
    }

    private Map<String, String> safeResponseHeaders(Map<String, String> map) {
        if (map != null) {
            return new HashMap<String, String>(map);
        }
        return new HashMap<String, String>();
    }
}

