/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.PlacementPolicy;
import org.apache.hadoop.yarn.service.api.records.ReadinessCheck;
import org.apache.hadoop.yarn.service.api.records.Resource;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="One or more components of the service. If the service is HBase say, then the component can be a simple role like master or regionserver. If the service is a complex business webapp then a component can be other services say Kafka or Storm. Thereby it opens up the support for complex and nested services.")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Component
implements Serializable {
    private static final long serialVersionUID = -8430058381509087805L;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="dependencies")
    private List<String> dependencies = new ArrayList<String>();
    @JsonProperty(value="readiness_check")
    @XmlElement(name="readiness_check")
    private ReadinessCheck readinessCheck = null;
    @JsonProperty(value="artifact")
    private Artifact artifact = null;
    @JsonProperty(value="launch_command")
    @XmlElement(name="launch_command")
    private String launchCommand = null;
    @JsonProperty(value="resource")
    private Resource resource = null;
    @JsonProperty(value="number_of_containers")
    @XmlElement(name="number_of_containers")
    private Long numberOfContainers = null;
    @JsonProperty(value="decommissioned_instances")
    @XmlElement(name="decommissioned_instances")
    private List<String> decommissionedInstances = new ArrayList<String>();
    @JsonProperty(value="run_privileged_container")
    @XmlElement(name="run_privileged_container")
    private Boolean runPrivilegedContainer = false;
    @JsonProperty(value="placement_policy")
    @XmlElement(name="placement_policy")
    private PlacementPolicy placementPolicy = null;
    @JsonProperty(value="state")
    private ComponentState state = ComponentState.FLEXING;
    @JsonProperty(value="configuration")
    private Configuration configuration = new Configuration();
    @JsonProperty(value="quicklinks")
    private List<String> quicklinks = new ArrayList<String>();
    @JsonProperty(value="containers")
    private List<Container> containers = Collections.synchronizedList(new ArrayList());
    @JsonProperty(value="restart_policy")
    @XmlElement(name="restart_policy")
    private RestartPolicyEnum restartPolicy = RestartPolicyEnum.ALWAYS;

    public Component restartPolicy(RestartPolicyEnum restartPolicyEnumVal) {
        this.restartPolicy = restartPolicyEnumVal;
        return this;
    }

    @ApiModelProperty(value="Policy of restart component. Including ALWAYS (Always restart component even if instance exit code = 0); ON_FAILURE (Only restart component if instance exit code != 0); NEVER (Do not restart in any cases)")
    public RestartPolicyEnum getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(RestartPolicyEnum restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public Component name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the service component (mandatory).")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component dependencies(List<String> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of service components which should be in READY state (as defined by readiness check), before this component can be started. The dependencies across all components of an service should be represented as a DAG.")
    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public Component readinessCheck(ReadinessCheck readinessCheck) {
        this.readinessCheck = readinessCheck;
        return this;
    }

    @ApiModelProperty(example="null", value="Readiness check for this component.")
    public ReadinessCheck getReadinessCheck() {
        return this.readinessCheck;
    }

    public void setReadinessCheck(ReadinessCheck readinessCheck) {
        this.readinessCheck = readinessCheck;
    }

    public Component artifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @ApiModelProperty(example="null", value="Artifact of the component (optional). If not specified, the service level global artifact takes effect.")
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Component launchCommand(String launchCommand) {
        this.launchCommand = launchCommand;
        return this;
    }

    @ApiModelProperty(example="null", value="The custom launch command of this component (optional). When specified at the component level, it overrides the value specified at the global level (if any).")
    public String getLaunchCommand() {
        return this.launchCommand;
    }

    public void setLaunchCommand(String launchCommand) {
        this.launchCommand = launchCommand;
    }

    public Component resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource of this component (optional). If not specified, the service level global resource takes effect.")
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Component numberOfContainers(Long numberOfContainers) {
        this.numberOfContainers = numberOfContainers;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of containers for this component (optional). If not specified, the service level global number_of_containers takes effect.")
    public Long getNumberOfContainers() {
        return this.numberOfContainers;
    }

    public void setNumberOfContainers(Long numberOfContainers) {
        this.numberOfContainers = numberOfContainers;
    }

    public Component decommissionedInstances(List<String> decommissionedInstances) {
        this.decommissionedInstances = decommissionedInstances;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of decommissioned component instances.")
    public List<String> getDecommissionedInstances() {
        return this.decommissionedInstances;
    }

    public void setDecommissionedInstances(List<String> decommissionedInstances) {
        this.decommissionedInstances = decommissionedInstances;
    }

    public void addDecommissionedInstance(String componentInstanceName) {
        this.decommissionedInstances.add(componentInstanceName);
    }

    @ApiModelProperty(example="null", value="Containers of a started component. Specifying a value for this attribute for the POST payload raises a validation error. This blob is available only in the GET response of a started service.")
    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public void addContainer(Container container) {
        this.containers.add(container);
    }

    public void removeContainer(Container container) {
        this.containers.remove(container);
    }

    public Container getContainer(String id) {
        for (Container container : this.containers) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        return null;
    }

    public Container getComponentInstance(String compInstanceName) {
        for (Container container : this.containers) {
            if (!compInstanceName.equals(container.getComponentInstanceName())) continue;
            return container;
        }
        return null;
    }

    public Component runPrivilegedContainer(Boolean runPrivilegedContainer) {
        this.runPrivilegedContainer = runPrivilegedContainer;
        return this;
    }

    @ApiModelProperty(example="null", value="Run all containers of this component in privileged mode (YARN-4262).")
    public Boolean getRunPrivilegedContainer() {
        return this.runPrivilegedContainer;
    }

    public void setRunPrivilegedContainer(Boolean runPrivilegedContainer) {
        this.runPrivilegedContainer = runPrivilegedContainer;
    }

    public Component placementPolicy(PlacementPolicy placementPolicy) {
        this.placementPolicy = placementPolicy;
        return this;
    }

    @ApiModelProperty(example="null", value="Advanced scheduling and placement policies for all containers of this component.")
    public PlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    public void setPlacementPolicy(PlacementPolicy placementPolicy) {
        this.placementPolicy = placementPolicy;
    }

    public Component configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @ApiModelProperty(example="null", value="Config properties for this component.")
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Component quicklinks(List<String> quicklinks) {
        this.quicklinks = quicklinks;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of quicklink keys defined at the service level, and to be resolved by this component.")
    public List<String> getQuicklinks() {
        return this.quicklinks;
    }

    public void setQuicklinks(List<String> quicklinks) {
        this.quicklinks = quicklinks;
    }

    public Component state(ComponentState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the component.")
    public ComponentState getState() {
        return this.state;
    }

    public void setState(ComponentState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return Objects.equals(this.name, component.name) && Objects.equals(this.dependencies, component.dependencies) && Objects.equals(this.readinessCheck, component.readinessCheck) && Objects.equals(this.artifact, component.artifact) && Objects.equals(this.launchCommand, component.launchCommand) && Objects.equals(this.resource, component.resource) && Objects.equals(this.numberOfContainers, component.numberOfContainers) && Objects.equals(this.runPrivilegedContainer, component.runPrivilegedContainer) && Objects.equals(this.placementPolicy, component.placementPolicy) && Objects.equals(this.configuration, component.configuration) && Objects.equals(this.quicklinks, component.quicklinks) && Objects.equals((Object)this.state, (Object)component.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dependencies, this.readinessCheck, this.artifact, this.launchCommand, this.resource, this.numberOfContainers, this.runPrivilegedContainer, this.placementPolicy, this.configuration, this.quicklinks, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Component {\n").append("    name: ").append(this.toIndentedString(this.name)).append("\n").append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n").append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n").append("    readinessCheck: ").append(this.toIndentedString(this.readinessCheck)).append("\n").append("    artifact: ").append(this.toIndentedString(this.artifact)).append("\n").append("    launchCommand: ").append(this.toIndentedString(this.launchCommand)).append("\n").append("    resource: ").append(this.toIndentedString(this.resource)).append("\n").append("    numberOfContainers: ").append(this.toIndentedString(this.numberOfContainers)).append("\n").append("    containers: ").append(this.toIndentedString(this.containers)).append("\n").append("    runPrivilegedContainer: ").append(this.toIndentedString(this.runPrivilegedContainer)).append("\n").append("    placementPolicy: ").append(this.toIndentedString(this.placementPolicy)).append("\n").append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n").append("    quicklinks: ").append(this.toIndentedString(this.quicklinks)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void mergeFrom(Component that) {
        if (this.getArtifact() == null) {
            this.setArtifact(that.getArtifact());
        }
        if (this.getResource() == null) {
            this.setResource(that.getResource());
        }
        if (this.getNumberOfContainers() == null) {
            this.setNumberOfContainers(that.getNumberOfContainers());
        }
        if (this.getLaunchCommand() == null) {
            this.setLaunchCommand(that.getLaunchCommand());
        }
        this.getConfiguration().mergeFrom(that.getConfiguration());
        if (this.getQuicklinks() == null) {
            this.setQuicklinks(that.getQuicklinks());
        }
        if (this.getRunPrivilegedContainer() == null) {
            this.setRunPrivilegedContainer(that.getRunPrivilegedContainer());
        }
        if (this.getDependencies() == null) {
            this.setDependencies(that.getDependencies());
        }
        if (this.getPlacementPolicy() == null) {
            this.setPlacementPolicy(that.getPlacementPolicy());
        }
        if (this.getReadinessCheck() == null) {
            this.setReadinessCheck(that.getReadinessCheck());
        }
    }

    public void overwrite(Component that) {
        this.setArtifact(that.getArtifact());
        this.setResource(that.resource);
        this.setNumberOfContainers(that.getNumberOfContainers());
        this.setLaunchCommand(that.getLaunchCommand());
        this.setConfiguration(that.configuration);
        this.setRunPrivilegedContainer(that.getRunPrivilegedContainer());
        this.setDependencies(that.getDependencies());
        this.setPlacementPolicy(that.getPlacementPolicy());
        this.setReadinessCheck(that.getReadinessCheck());
    }

    @XmlType(name="restart_policy")
    @XmlEnum
    public static enum RestartPolicyEnum {
        ALWAYS("ALWAYS"),
        ON_FAILURE("ON_FAILURE"),
        NEVER("NEVER");

        private String value;

        private RestartPolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

