/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetSocketAddress;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.RMInfoMXBean;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMInfo
implements RMInfoMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(RMNMInfo.class);
    private ResourceManager resourceManager;
    private ObjectName rmStatusBeanName;

    RMInfo(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void register() {
        try {
            StandardMBean bean = new StandardMBean(this, RMInfoMXBean.class);
            this.rmStatusBeanName = MBeans.register((String)"ResourceManager", (String)"RMInfo", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn("Error registering RMInfo MBean", (Throwable)e);
        }
        LOG.info("Registered RMInfo MBean");
    }

    public void unregister() {
        if (this.rmStatusBeanName != null) {
            MBeans.unregister((ObjectName)this.rmStatusBeanName);
        }
    }

    @Override
    public String getState() {
        return this.resourceManager.getRMContext().getHAServiceState().toString();
    }

    @Override
    public String getHostAndPort() {
        return NetUtils.getHostPortString((InetSocketAddress)ResourceManager.getBindAddress(this.resourceManager.getRMContext().getYarnConfiguration()));
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }
}

