/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.mapreduce.lib.db.TextSplitter;
import org.junit.Assert;
import org.junit.Test;

public class TestTextSplitter {
    public String formatArray(Object[] ar) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object val : ar) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(val.toString());
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public void assertArrayEquals(Object[] expected, Object[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            try {
                Assert.assertEquals((String)("Failure at position " + i + "; got " + actual[i] + " instead of " + expected[i] + "; actual array is " + this.formatArray(actual)), (Object)expected[i], (Object)actual[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                Assert.fail((String)("Expected array with " + expected.length + " elements; got " + actual.length + ". Actual array is " + this.formatArray(actual)));
            }
        }
        if (actual.length > expected.length) {
            Assert.fail((String)("Actual array has " + actual.length + " elements; expected " + expected.length + ". Actual array is " + this.formatArray(actual)));
        }
    }

    @Test
    public void testStringConvertEmpty() {
        TextSplitter splitter = new TextSplitter();
        BigDecimal emptyBigDec = splitter.stringToBigDecimal("");
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)emptyBigDec);
    }

    @Test
    public void testBigDecConvertEmpty() {
        TextSplitter splitter = new TextSplitter();
        String emptyStr = splitter.bigDecimalToString(BigDecimal.ZERO);
        Assert.assertEquals((Object)"", (Object)emptyStr);
    }

    @Test
    public void testConvertA() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("A"));
        Assert.assertEquals((Object)"A", (Object)out);
    }

    @Test
    public void testConvertZ() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("Z"));
        Assert.assertEquals((Object)"Z", (Object)out);
    }

    @Test
    public void testConvertThreeChars() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("abc"));
        Assert.assertEquals((Object)"abc", (Object)out);
    }

    @Test
    public void testConvertStr() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("big str"));
        Assert.assertEquals((Object)"big str", (Object)out);
    }

    @Test
    public void testConvertChomped() {
        TextSplitter splitter = new TextSplitter();
        String out = splitter.bigDecimalToString(splitter.stringToBigDecimal("AVeryLongStringIndeed"));
        Assert.assertEquals((Object)"AVeryLon", (Object)out);
    }

    @Test
    public void testAlphabetSplit() throws SQLException {
        TextSplitter splitter = new TextSplitter();
        List splits = splitter.split(25, "A", "Z", "");
        Object[] expected = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        this.assertArrayEquals(expected, splits.toArray(new String[0]));
    }

    @Test
    public void testCommonPrefix() throws SQLException {
        TextSplitter splitter = new TextSplitter();
        List splits = splitter.split(5, "nd", "rdy", "Ha");
        Assert.assertEquals((Object)"Hand", splits.get(0));
        Assert.assertEquals((Object)"Hardy", splits.get(splits.size() - 1));
        Assert.assertEquals((long)6L, (long)splits.size());
    }
}

