/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;
import org.ojalgo.scalar.Scalar;

final class ColumnsStore<N extends Number>
extends SelectingStore<N> {
    private final int[] myColumns;

    ColumnsStore(MatrixStore<N> base, int ... columns) {
        super(base, (int)base.countRows(), columns.length);
        this.myColumns = columns;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.getBase().doubleValue(row, this.myColumns[(int)col]);
    }

    @Override
    public int firstInColumn(int col) {
        return this.getBase().firstInColumn(this.myColumns[col]);
    }

    @Override
    public N get(long row, long col) {
        return this.getBase().get(row, this.myColumns[(int)col]);
    }

    @Override
    public int limitOfColumn(int col) {
        return this.getBase().limitOfColumn(this.myColumns[col]);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.getBase().toScalar(row, this.myColumns[(int)column]);
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
        MatrixStore tmpBase = this.getBase();
        for (int c = 0; c < this.myColumns.length; ++c) {
            consumer.fillColumn(0L, (long)c, tmpBase.sliceColumn(0L, this.myColumns[c]));
        }
    }
}

