/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import com.aliyun.oss.common.utils.StringUtils;

public class SystemPropertiesCredentialsProvider
implements CredentialsProvider {
    @Override
    public void setCredentials(Credentials creds) {
    }

    @Override
    public Credentials getCredentials() {
        String accessKeyId = StringUtils.trim(System.getProperty("oss.accessKeyId"));
        String secretAccessKey = StringUtils.trim(System.getProperty("oss.accessKeySecret"));
        String sessionToken = StringUtils.trim(System.getProperty("oss.sessionToken"));
        if (accessKeyId == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
        if (secretAccessKey == null || secretAccessKey.equals("")) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }
        return new DefaultCredentials(accessKeyId, secretAccessKey, sessionToken);
    }
}

