/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.random.Deterministic;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.CoordinationSet;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public abstract class FinanceUtils {
    public static double calculateValueAtRisk(double expRet, double stdDev, double confidence, double time) {
        double tmpConfidenceScale = PrimitiveMath.SQRT_TWO * RandomUtils.erfi(PrimitiveMath.ONE - PrimitiveMath.TWO * (PrimitiveMath.ONE - confidence));
        return PrimitiveFunction.MAX.invoke(PrimitiveFunction.SQRT.invoke(time) * stdDev * tmpConfidenceScale - time * expRet, PrimitiveMath.ZERO);
    }

    public static GeometricBrownianMotion estimateExcessDiffusionProcess(CalendarDateSeries<?> priceSeries, CalendarDateSeries<?> riskFreeInterestRateSeries, CalendarDateUnit timeUnit) {
        SampleSet tmpSampleSet = FinanceUtils.makeExcessGrowthRateSampleSet(priceSeries, riskFreeInterestRateSeries);
        double tmpStepSize = priceSeries.getResolution().size();
        double tmpExp = tmpSampleSet.getMean();
        double tmpVar = tmpSampleSet.getVariance();
        double tmpDiff = PrimitiveFunction.SQRT.invoke(tmpVar / (tmpStepSize /= (double)timeUnit.size()));
        double tmpDrift = tmpExp / tmpStepSize + tmpDiff * tmpDiff / PrimitiveMath.TWO;
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        return retVal;
    }

    public static CalendarDateSeries<RandomNumber> forecast(CalendarDateSeries<? extends Number> series, int pointCount, CalendarDateUnit timeUnit, boolean includeOriginalSeries) {
        CalendarDateSeries<RandomNumber> retVal = new CalendarDateSeries<RandomNumber>(timeUnit);
        ((CalendarDateSeries)retVal.name(series.getName())).colour(series.getColour());
        double tmpSamplePeriod = (double)series.getAverageStepSize() / (double)timeUnit.size();
        GeometricBrownianMotion tmpProcess = GeometricBrownianMotion.estimate(series.asPrimitive(), tmpSamplePeriod);
        if (includeOriginalSeries) {
            for (Map.Entry tmpEntry : series.entrySet()) {
                retVal.put((CalendarDate)tmpEntry.getKey(), (RandomNumber)new Deterministic((Number)tmpEntry.getValue()));
            }
        }
        CalendarDate tmpLastKey = (CalendarDate)series.lastKey();
        double tmpLastValue = series.lastValue().doubleValue();
        tmpProcess.setValue(tmpLastValue);
        for (int i = 1; i <= pointCount; ++i) {
            retVal.put(tmpLastKey.millis + (long)i * timeUnit.size(), (RandomNumber)tmpProcess.getDistribution(i));
        }
        return retVal;
    }

    public static CalendarDateSeries<BigDecimal> makeCalendarPriceSeries(double[] prices, Calendar startCalendar, CalendarDateUnit resolution) {
        CalendarDateSeries<BigDecimal> retVal = new CalendarDateSeries<BigDecimal>(resolution);
        FinanceUtils.copyValues(retVal, new CalendarDate(startCalendar), prices);
        return retVal;
    }

    public static <V extends Number> BasicMatrix makeCovarianceMatrix(Collection<CalendarDateSeries<V>> timeSeriesCollection) {
        CoordinationSet tmpCoordinator = new CoordinationSet(timeSeriesCollection).prune();
        ArrayList<SampleSet> tmpSampleSets = new ArrayList<SampleSet>();
        for (CalendarDateSeries tmpTimeSeries : timeSeriesCollection) {
            double[] values = tmpCoordinator.get(tmpTimeSeries.getName()).asPrimitive().toRawCopy1D();
            int tmpSize1 = values.length - 1;
            double[] retVal = new double[tmpSize1];
            for (int i = 0; i < tmpSize1; ++i) {
                retVal[i] = PrimitiveFunction.LOG.invoke(values[i + 1] / values[i]);
            }
            SampleSet tmpMakeUsingLogarithmicChanges = SampleSet.wrap(ArrayUtils.wrapAccess1D(retVal));
            tmpSampleSets.add(tmpMakeUsingLogarithmicChanges);
        }
        int tmpSize = timeSeriesCollection.size();
        BasicMatrix.Builder<PrimitiveMatrix> retValStore = PrimitiveMatrix.FACTORY.getBuilder(tmpSize, tmpSize);
        double tmpToYearFactor = (double)CalendarDateUnit.YEAR.size() / (double)tmpCoordinator.getResolution().size();
        for (int j = 0; j < tmpSize; ++j) {
            SampleSet tmpColSet = (SampleSet)tmpSampleSets.get(j);
            for (int i = 0; i < tmpSize; ++i) {
                SampleSet tmpRowSet = (SampleSet)tmpSampleSets.get(i);
                retValStore.set((long)i, (long)j, tmpToYearFactor * tmpRowSet.getCovariance(tmpColSet));
            }
        }
        return retValStore.build();
    }

    public static <N extends Number> PrimitiveMatrix makeCovarianceMatrix(List<CalendarDateSeries<N>> listOfTimeSeries, boolean mayBeMissingValues) {
        int tmpSize = listOfTimeSeries.size();
        CoordinationSet<N> tmpUncoordinated = new CoordinationSet<N>(listOfTimeSeries);
        CalendarDateUnit tmpDataResolution = tmpUncoordinated.getResolution();
        if (mayBeMissingValues) {
            tmpUncoordinated.complete();
        }
        CoordinationSet<N> tmpCoordinated = tmpUncoordinated.prune(tmpDataResolution);
        BasicMatrix.Builder<PrimitiveMatrix> tmpMatrixBuilder = PrimitiveMatrix.FACTORY.getBuilder(tmpSize, tmpSize);
        double tmpToYearFactor = (double)CalendarDateUnit.YEAR.size() / (double)tmpDataResolution.size();
        SampleSet[] tmpSampleSets = new SampleSet[tmpSize];
        for (int j = 0; j < tmpSize; ++j) {
            PrimitiveSeries tmpPrimitiveSeries = tmpCoordinated.get(listOfTimeSeries.get(j).getName()).asPrimitive();
            SampleSet tmpSampleSet = SampleSet.wrap(tmpPrimitiveSeries.quotients().log().toDataSeries());
            tmpMatrixBuilder.set((long)j, (long)j, tmpToYearFactor * tmpSampleSet.getVariance());
            for (int i = 0; i < j; ++i) {
                double tmpCovariance = tmpToYearFactor * tmpSampleSets[i].getCovariance(tmpSampleSet);
                tmpMatrixBuilder.set((long)i, (long)j, tmpCovariance);
                tmpMatrixBuilder.set((long)j, (long)i, tmpCovariance);
            }
            tmpSampleSets[j] = tmpSampleSet;
        }
        return (PrimitiveMatrix)tmpMatrixBuilder.get();
    }

    public static CalendarDateSeries<BigDecimal> makeDatePriceSeries(double[] prices, Date startDate, CalendarDateUnit resolution) {
        CalendarDateSeries<BigDecimal> retVal = new CalendarDateSeries<BigDecimal>(resolution);
        FinanceUtils.copyValues(retVal, new CalendarDate(startDate), prices);
        return retVal;
    }

    public static SampleSet makeExcessGrowthRateSampleSet(CalendarDateSeries<?> priceSeries, CalendarDateSeries<?> riskFreeInterestRateSeries) {
        if (priceSeries.size() != riskFreeInterestRateSeries.size()) {
            throw new IllegalArgumentException("The two series must have the same size (number of elements).");
        }
        if (!((CalendarDate)priceSeries.firstKey()).equals(riskFreeInterestRateSeries.firstKey())) {
            throw new IllegalArgumentException("The two series must have the same first key (date or calendar).");
        }
        if (!((CalendarDate)priceSeries.lastKey()).equals(riskFreeInterestRateSeries.lastKey())) {
            throw new IllegalArgumentException("The two series must have the same last key (date or calendar).");
        }
        double[] tmpPrices = priceSeries.asPrimitive().toRawCopy1D();
        double[] tmpRiskFreeInterestRates = riskFreeInterestRateSeries.asPrimitive().toRawCopy1D();
        Structure1D retVal = Array1D.PRIMITIVE64.makeZero(tmpPrices.length - 1);
        CalendarDateUnit tmpUnit = priceSeries.getResolution();
        for (int i = 0; i < ((Array1D)retVal).size(); ++i) {
            double tmpThisRiskFree = tmpRiskFreeInterestRates[i] / PrimitiveMath.HUNDRED;
            double tmpNextRiskFree = tmpRiskFreeInterestRates[i + 1] / PrimitiveMath.HUNDRED;
            double tmpAvgRiskFree = (tmpThisRiskFree + tmpNextRiskFree) / PrimitiveMath.TWO;
            double tmpRiskFreeGrowthRate = FinanceUtils.toGrowthRateFromAnnualReturn(tmpAvgRiskFree, tmpUnit);
            double tmpThisPrice = tmpPrices[i];
            double tmpNextPrice = tmpPrices[i + 1];
            double tmpPriceGrowthFactor = tmpNextPrice / tmpThisPrice;
            double tmpPriceGrowthRate = PrimitiveFunction.LOG.invoke(tmpPriceGrowthFactor);
            double tmpAdjustedPriceGrowthRate = tmpPriceGrowthRate - tmpRiskFreeGrowthRate;
            ((Array1D)retVal).set((long)i, tmpAdjustedPriceGrowthRate);
        }
        return SampleSet.wrap(retVal);
    }

    public static CalendarDateSeries<Double> makeNormalisedExcessPrice(CalendarDateSeries<?> priceSeries, CalendarDateSeries<?> riskFreeInterestRateSeries) {
        if (priceSeries.size() != riskFreeInterestRateSeries.size()) {
            throw new IllegalArgumentException("The two series must have the same size (number of elements).");
        }
        if (!((CalendarDate)priceSeries.firstKey()).equals(riskFreeInterestRateSeries.firstKey())) {
            throw new IllegalArgumentException("The two series must have the same first key (date or calendar).");
        }
        if (!((CalendarDate)priceSeries.lastKey()).equals(riskFreeInterestRateSeries.lastKey())) {
            throw new IllegalArgumentException("The two series must have the same last key (date or calendar).");
        }
        long[] tmpDates = priceSeries.getPrimitiveKeys();
        double[] tmpPrices = priceSeries.asPrimitive().toRawCopy1D();
        double[] tmpRiskFreeInterestRates = riskFreeInterestRateSeries.asPrimitive().toRawCopy1D();
        CalendarDateUnit tmpResolution = priceSeries.getResolution();
        CalendarDateSeries retVal = new CalendarDateSeries(tmpResolution);
        double tmpAggregatedExcessPrice = PrimitiveMath.ONE;
        retVal.put(new CalendarDate(tmpDates[0]), tmpAggregatedExcessPrice);
        for (int i = 1; i < priceSeries.size(); ++i) {
            double tmpThisRiskFree = tmpRiskFreeInterestRates[i] / PrimitiveMath.HUNDRED;
            double tmpLastRiskFree = tmpRiskFreeInterestRates[i - 1] / PrimitiveMath.HUNDRED;
            double tmpAvgRiskFree = (tmpThisRiskFree + tmpLastRiskFree) / PrimitiveMath.TWO;
            double tmpRiskFreeGrowthFactor = FinanceUtils.toGrowthFactorFromAnnualReturn(tmpAvgRiskFree, tmpResolution);
            double tmpThisPrice = tmpPrices[i];
            double tmpLastPrice = tmpPrices[i - 1];
            double tmpPriceGrowthFactor = tmpThisPrice / tmpLastPrice;
            double tmpAdjustedPriceGrowthFactor = tmpPriceGrowthFactor / tmpRiskFreeGrowthFactor;
            retVal.put(new CalendarDate(tmpDates[i]), tmpAggregatedExcessPrice *= tmpAdjustedPriceGrowthFactor);
        }
        return (CalendarDateSeries)((CalendarDateSeries)retVal.name(priceSeries.getName())).colour(priceSeries.getColour());
    }

    public static double toAnnualReturnFromGrowthFactor(double growthFactor, CalendarDateUnit growthFactorUnit) {
        double tmpGrowthFactorUnitsPerYear = growthFactorUnit.convert(CalendarDateUnit.YEAR);
        return PrimitiveFunction.POW.invoke(growthFactor, tmpGrowthFactorUnitsPerYear) - PrimitiveMath.ONE;
    }

    public static double toAnnualReturnFromGrowthRate(double growthRate, CalendarDateUnit growthRateUnit) {
        double tmpGrowthRateUnitsPerYear = growthRateUnit.convert(CalendarDateUnit.YEAR);
        return PrimitiveFunction.EXPM1.invoke(growthRate * tmpGrowthRateUnitsPerYear);
    }

    public static PrimitiveMatrix toCorrelations(Access2D<?> covariances) {
        return FinanceUtils.toCorrelations(covariances, false);
    }

    public static PrimitiveMatrix toCorrelations(Access2D<?> covariances, boolean clean) {
        int tmpSize = (int)Math.min(covariances.countRows(), covariances.countColumns());
        MatrixStore<PhysicalStore<Double>> tmpCovariances = MatrixStore.PRIMITIVE.makeWrapper(covariances).get();
        if (clean) {
            Eigenvalue<Double> tmpEvD = Eigenvalue.PRIMITIVE.make(true);
            tmpEvD.decompose((Access2D.Collectable<Double, PhysicalStore<Double>>)tmpCovariances);
            MatrixStore<Double> tmpV = tmpEvD.getV();
            PhysicalStore<Double> tmpD = tmpEvD.getD().copy();
            double tmpLargest = ((ComplexNumber)tmpEvD.getEigenvalues().get(0)).norm();
            double tmpLimit = tmpLargest * (double)tmpSize * PrimitiveFunction.SQRT.invoke(PrimitiveMath.MACHINE_EPSILON);
            for (int ij = 0; ij < tmpSize; ++ij) {
                if (!(tmpD.doubleValue(ij, ij) < tmpLimit)) continue;
                tmpD.set((long)ij, (long)ij, tmpLimit);
            }
            MatrixStore<Double> tmpLeft = tmpV;
            PhysicalStore<Double> tmpMiddle = tmpD;
            ElementsSupplier tmpRight = tmpLeft.transpose();
            tmpCovariances = tmpLeft.multiply((Double)((Object)tmpMiddle)).multiply((PhysicalStore<Double>)tmpRight);
        }
        BasicMatrix.Builder<PrimitiveMatrix> retVal = PrimitiveMatrix.FACTORY.getBuilder(tmpSize, tmpSize);
        double[] tmpVolatilities = new double[tmpSize];
        for (int ij = 0; ij < tmpSize; ++ij) {
            tmpVolatilities[ij] = PrimitiveFunction.SQRT.invoke(tmpCovariances.doubleValue(ij, ij));
        }
        for (int j = 0; j < tmpSize; ++j) {
            double tmpColVol = tmpVolatilities[j];
            retVal.set((long)j, (long)j, PrimitiveMath.ONE);
            for (int i = j + 1; i < tmpSize; ++i) {
                double tmpCovariance = tmpCovariances.doubleValue(i, j);
                double tmpCorrelation = tmpCovariance / (tmpVolatilities[i] * tmpColVol);
                retVal.set((long)i, (long)j, tmpCorrelation);
                retVal.set((long)j, (long)i, tmpCorrelation);
            }
        }
        return (PrimitiveMatrix)retVal.get();
    }

    public static PrimitiveMatrix toCovariances(Access1D<?> volatilities, Access2D<?> correlations) {
        int tmpSize = (int)volatilities.count();
        BasicMatrix.Builder<PrimitiveMatrix> retVal = PrimitiveMatrix.FACTORY.getBuilder(tmpSize, tmpSize);
        for (int j = 0; j < tmpSize; ++j) {
            double tmpColumnVolatility = volatilities.doubleValue(j);
            retVal.set((long)j, (long)j, tmpColumnVolatility * tmpColumnVolatility);
            for (int i = j + 1; i < tmpSize; ++i) {
                double tmpCovariance = volatilities.doubleValue(i) * correlations.doubleValue(i, j) * tmpColumnVolatility;
                retVal.set((long)i, (long)j, tmpCovariance);
                retVal.set((long)j, (long)i, tmpCovariance);
            }
        }
        return (PrimitiveMatrix)retVal.get();
    }

    public static double toGrowthFactorFromAnnualReturn(double annualReturn, CalendarDateUnit growthFactorUnit) {
        double tmpAnnualGrowthFactor = PrimitiveMath.ONE + annualReturn;
        double tmpYearsPerGrowthFactorUnit = CalendarDateUnit.YEAR.convert(growthFactorUnit);
        return PrimitiveFunction.POW.invoke(tmpAnnualGrowthFactor, tmpYearsPerGrowthFactorUnit);
    }

    public static double toGrowthRateFromAnnualReturn(double annualReturn, CalendarDateUnit growthRateUnit) {
        double tmpAnnualGrowthRate = PrimitiveFunction.LOG1P.invoke(annualReturn);
        double tmpYearsPerGrowthRateUnit = CalendarDateUnit.YEAR.convert(growthRateUnit);
        return tmpAnnualGrowthRate * tmpYearsPerGrowthRateUnit;
    }

    public static PrimitiveMatrix toVolatilities(Access2D<?> covariances) {
        return FinanceUtils.toVolatilities(covariances, false);
    }

    public static PrimitiveMatrix toVolatilities(Access2D<?> covariances, boolean clean) {
        int tmpSize = (int)Math.min(covariances.countRows(), covariances.countColumns());
        BasicMatrix.Builder<PrimitiveMatrix> retVal = PrimitiveMatrix.FACTORY.getBuilder(tmpSize);
        if (clean) {
            AggregatorFunction<Double> tmpLargest = PrimitiveAggregator.LARGEST.get();
            MatrixStore.PRIMITIVE.makeWrapper(covariances).get().visitDiagonal(0L, 0L, tmpLargest);
            double tmpLimit = tmpLargest.doubleValue() * (double)tmpSize * PrimitiveFunction.SQRT.invoke(PrimitiveMath.MACHINE_EPSILON);
            for (int ij = 0; ij < tmpSize; ++ij) {
                double tmpVariance = covariances.doubleValue(ij, ij);
                if (tmpVariance < tmpLimit) {
                    retVal.set((long)ij, PrimitiveFunction.SQRT.invoke(tmpLimit));
                    continue;
                }
                retVal.set((long)ij, PrimitiveFunction.SQRT.invoke(tmpVariance));
            }
        } else {
            for (int ij = 0; ij < tmpSize; ++ij) {
                retVal.set((long)ij, PrimitiveFunction.SQRT.invoke(covariances.doubleValue(ij, ij)));
            }
        }
        return (PrimitiveMatrix)retVal.get();
    }

    private static <K extends Comparable<? super K>> void copyValues(CalendarDateSeries<BigDecimal> series, CalendarDate firstKey, double[] values) {
        CalendarDate tmpKey = firstKey;
        for (int tmpValueIndex = 0; tmpValueIndex < values.length; ++tmpValueIndex) {
            series.put(tmpKey, new BigDecimal(values[tmpValueIndex]));
            tmpKey = series.step(tmpKey);
        }
    }

    private FinanceUtils() {
    }
}

