/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFileCreationDelete {
    public TestFileCreationDelete() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationDeleteParent() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path dir = new Path("/foo");
            Path file1 = new Path(dir, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1, 1000);
            stm1.hflush();
            Path file2 = new Path("/file2");
            FSDataOutputStream stm2 = TestFileCreation.createFile((FileSystem)fs, file2, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file2);
            TestFileCreation.writeFile(stm2, 1000);
            stm2.hflush();
            fs.delete(dir, true);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.exists(file2));
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

