/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestDataDirs {
    @Test(timeout=30000L)
    public void testDataDirParsing() throws Throwable {
        Configuration conf = new Configuration();
        File dir0 = new File("/dir0");
        File dir1 = new File("/dir1");
        File dir2 = new File("/dir2");
        File dir3 = new File("/dir3");
        File dir4 = new File("/dir4");
        File dir5 = new File("/dir5");
        File dir6 = new File("/dir6");
        String locations1 = "[disk]/dir0,[DISK]/dir1,[sSd]/dir2,[disK]/dir3,[ram_disk]/dir4,[disk]/dir5, [disk] /dir6, [disk] ";
        conf.set("dfs.datanode.data.dir", locations1);
        List locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)8));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getUri(), (Matcher)CoreMatchers.is((Object)dir0.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getUri(), (Matcher)CoreMatchers.is((Object)dir1.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(2)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.SSD));
        Assert.assertThat((Object)((StorageLocation)locations.get(2)).getUri(), (Matcher)CoreMatchers.is((Object)dir2.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(3)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(3)).getUri(), (Matcher)CoreMatchers.is((Object)dir3.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(4)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.RAM_DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(4)).getUri(), (Matcher)CoreMatchers.is((Object)dir4.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(5)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(5)).getUri(), (Matcher)CoreMatchers.is((Object)dir5.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(6)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(6)).getUri(), (Matcher)CoreMatchers.is((Object)dir6.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(7)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        String locations2 = "[BadMediaType]/dir0,[ssd]/dir1,[disk]/dir2";
        conf.set("dfs.datanode.data.dir", locations2);
        try {
            locations = DataNode.getStorageLocations((Configuration)conf);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            DataNode.LOG.info("The exception is expected.", (Throwable)iae);
        }
        String locations3 = "/dir0,/dir1";
        conf.set("dfs.datanode.data.dir", locations3);
        locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getUri(), (Matcher)CoreMatchers.is((Object)dir0.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getUri(), (Matcher)CoreMatchers.is((Object)dir1.toURI()));
    }
}

