/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.examples.AggregateWordCount;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorJob;

public class AggregateWordHistogram {
    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = ValueAggregatorJob.createValueAggregatorJob((String[])args, (Class[])new Class[]{AggregateWordHistogramPlugin.class});
        job.setJarByClass(AggregateWordCount.class);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        System.exit(ret);
    }

    public static class AggregateWordHistogramPlugin
    extends ValueAggregatorBaseDescriptor {
        public ArrayList<Map.Entry<Text, Text>> generateKeyValPairs(Object key, Object val) {
            String[] words = val.toString().split(" |\t");
            ArrayList<Map.Entry<Text, Text>> retv = new ArrayList<Map.Entry<Text, Text>>();
            for (int i = 0; i < words.length; ++i) {
                Text valCount = new Text(words[i] + "\t" + "1");
                Map.Entry en = AggregateWordHistogramPlugin.generateEntry((String)"ValueHistogram", (String)"WORD_HISTOGRAM", (Text)valCount);
                retv.add(en);
            }
            return retv;
        }
    }
}

