/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProxyUsers {
    private static final Logger LOG = LoggerFactory.getLogger(TestProxyUsers.class);
    private static final String REAL_USER_NAME = "proxier";
    private static final String PROXY_USER_NAME = "proxied_user";
    private static final String AUTHORIZED_PROXY_USER_NAME = "authorized_proxied_user";
    private static final String[] GROUP_NAMES = new String[]{"foo_group"};
    private static final String[] NETGROUP_NAMES = new String[]{"@foo_group"};
    private static final String[] OTHER_GROUP_NAMES = new String[]{"bar_group"};
    private static final String[] SUDO_GROUP_NAMES = new String[]{"sudo_proxied_user"};
    private static final String PROXY_IP = "1.2.3.4";
    private static final String PROXY_IP_RANGE = "10.222.0.0/16,10.113.221.221";

    @Test
    public void testNetgroups() throws IOException {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            LOG.info("Not testing netgroups, this test only runs when native code is compiled");
            return;
        }
        String groupMappingClassName = System.getProperty("TestProxyUsersGroupMapping");
        if (groupMappingClassName == null) {
            LOG.info("Not testing netgroups, no group mapping class specified, use -DTestProxyUsersGroupMapping=$className to specify group mapping class (must implement GroupMappingServiceProvider interface and support netgroups)");
            return;
        }
        LOG.info("Testing netgroups using: " + groupMappingClassName);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", groupMappingClassName);
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(NETGROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])groups.getGroups(PROXY_USER_NAME).toArray(new String[groups.getGroups(PROXY_USER_NAME).size()]));
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
    }

    @Test
    public void testProxyUsers() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testProxyUsersWithUserConf() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserUserConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(AUTHORIZED_PROXY_USER_NAME)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)AUTHORIZED_PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testWildcardGroup() {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), "*");
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testWildcardUser() {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserUserConfKey(REAL_USER_NAME), "*");
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)AUTHORIZED_PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testWildcardIP() {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testIPRange() {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), "*");
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP_RANGE);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, "10.222.0.0");
        this.assertNotAuthorized(proxyUserUgi, "10.221.0.0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullUser() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), "*");
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP_RANGE);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        ProxyUsers.authorize(null, (String)"10.222.0.0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIpAddress() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), "*");
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP_RANGE);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        ProxyUsers.authorize((UserGroupInformation)proxyUserUgi, null);
    }

    @Test
    public void testWithDuplicateProxyGroups() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES, GROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        Collection groupsToBeProxied = (Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME));
        Assert.assertEquals((long)1L, (long)groupsToBeProxied.size());
    }

    @Test
    public void testWithDuplicateProxyHosts() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(PROXY_IP, PROXY_IP)));
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        Collection hosts = (Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME));
        Assert.assertEquals((long)1L, (long)hosts.size());
    }

    @Test
    public void testProxyUsersWithProviderOverride() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.impersonation.provider.class", "org.apache.hadoop.security.authorize.TestProxyUsers$TestDummyImpersonationProvider");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createUserForTesting((String)REAL_USER_NAME, (String[])SUDO_GROUP_NAMES);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createUserForTesting((String)REAL_USER_NAME, (String[])GROUP_NAMES);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testWithProxyGroupsAndUsersWithSpaces() throws Exception {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserUserConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList("proxied_user ", AUTHORIZED_PROXY_USER_NAME, "ONEMORE")));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        Collection groupsToBeProxied = (Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME));
        Assert.assertEquals((long)GROUP_NAMES.length, (long)groupsToBeProxied.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProxyUsersWithNullPrefix() throws Exception {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)new Configuration(false), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProxyUsersWithEmptyPrefix() throws Exception {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)new Configuration(false), (String)"");
    }

    @Test
    public void testProxyUsersWithCustomPrefix() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("x.proxier.users", StringUtils.join((CharSequence)",", Arrays.asList(AUTHORIZED_PROXY_USER_NAME)));
        conf.set("x.proxier.hosts", PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf, (String)"x");
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)AUTHORIZED_PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    @Test
    public void testNoHostsForUsers() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("y.proxier.users", StringUtils.join((CharSequence)",", Arrays.asList(AUTHORIZED_PROXY_USER_NAME)));
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf, (String)"y");
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)AUTHORIZED_PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
    }

    private void assertNotAuthorized(UserGroupInformation proxyUgi, String host) {
        try {
            ProxyUsers.authorize((UserGroupInformation)proxyUgi, (String)host);
            Assert.fail((String)("Allowed authorization of " + proxyUgi + " from " + host));
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    private void assertAuthorized(UserGroupInformation proxyUgi, String host) {
        try {
            ProxyUsers.authorize((UserGroupInformation)proxyUgi, (String)host);
        }
        catch (AuthorizationException e) {
            Assert.fail((String)("Did not allow authorization of " + proxyUgi + " from " + host));
        }
    }

    public static void loadTest(String ipString, int testRange) {
        Configuration conf = new Configuration();
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(REAL_USER_NAME), ipString);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        long startTime = System.nanoTime();
        SecureRandom sr = new SecureRandom();
        for (int i = 1; i < 1000000; ++i) {
            try {
                ProxyUsers.authorize((UserGroupInformation)proxyUserUgi, (String)("1.2.3." + sr.nextInt(testRange)));
                continue;
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
        long stopTime = System.nanoTime();
        long elapsedTime = stopTime - startTime;
        System.out.println(elapsedTime / 1000000L + " ms");
    }

    public static void main(String[] args) {
        String ipValues = null;
        if (args.length != 3 || !args[0].equals("ip") && !args[0].equals("range")) {
            System.out.println("Invalid invocation. The right syntax is ip/range <numberofIps/cidr> <testRange>");
        } else {
            if (args[0].equals("ip")) {
                int numberOfIps = Integer.parseInt(args[1]);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < numberOfIps; ++i) {
                    sb.append("1.2.3." + i + ",");
                }
                ipValues = sb.toString();
            } else if (args[0].equals("range")) {
                ipValues = args[1];
            }
            int testRange = Integer.parseInt(args[2]);
            TestProxyUsers.loadTest(ipValues, testRange);
        }
    }

    static class TestDummyImpersonationProvider
    implements ImpersonationProvider {
        TestDummyImpersonationProvider() {
        }

        public void init(String configurationPrefix) {
        }

        public void authorize(UserGroupInformation user, String remoteAddress) throws AuthorizationException {
            UserGroupInformation superUser = user.getRealUser();
            String sudoGroupName = "sudo_" + user.getShortUserName();
            if (!Arrays.asList(superUser.getGroupNames()).contains(sudoGroupName)) {
                throw new AuthorizationException("User: " + superUser.getUserName() + " is not allowed to impersonate " + user.getUserName());
            }
        }

        public void setConf(Configuration conf) {
        }

        public Configuration getConf() {
            return null;
        }
    }
}

