/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.google.common.util.concurrent.MoreExecutors;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileReaderTask;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.ReadBuffer;

public class AliyunOSSInputStream
extends FSInputStream {
    public static final Log LOG = LogFactory.getLog(AliyunOSSInputStream.class);
    private final long downloadPartSize;
    private AliyunOSSFileSystemStore store;
    private final String key;
    private FileSystem.Statistics statistics;
    private boolean closed;
    private long contentLength;
    private long position;
    private long partRemaining;
    private byte[] buffer;
    private int maxReadAheadPartNumber;
    private long expectNextPos;
    private long lastByteStart;
    private ExecutorService readAheadExecutorService;
    private Queue<ReadBuffer> readBufferQueue = new ArrayDeque<ReadBuffer>();

    public AliyunOSSInputStream(Configuration conf, ExecutorService readAheadExecutorService, int maxReadAheadPartNumber, AliyunOSSFileSystemStore store, String key, Long contentLength, FileSystem.Statistics statistics) throws IOException {
        this.readAheadExecutorService = MoreExecutors.listeningDecorator((ExecutorService)readAheadExecutorService);
        this.store = store;
        this.key = key;
        this.statistics = statistics;
        this.contentLength = contentLength;
        this.downloadPartSize = conf.getLong("fs.oss.multipart.download.size", 524288L);
        this.maxReadAheadPartNumber = maxReadAheadPartNumber;
        this.expectNextPos = 0L;
        this.lastByteStart = -1L;
        this.reopen(0L);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reopen(long pos) throws IOException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek at negative position:" + pos);
        }
        if (pos > this.contentLength) {
            throw new EOFException("Cannot seek after EOF, contentLength:" + this.contentLength + " position:" + pos);
        }
        long partSize = pos + this.downloadPartSize > this.contentLength ? this.contentLength - pos : this.downloadPartSize;
        if (this.buffer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Aborting old stream to open at pos " + pos));
            }
            this.buffer = null;
        }
        boolean isRandomIO = true;
        if (pos == this.expectNextPos) {
            isRandomIO = false;
        } else {
            while (this.readBufferQueue.size() != 0 && this.readBufferQueue.element().getByteStart() != pos) {
                this.readBufferQueue.poll();
            }
        }
        this.expectNextPos = pos + partSize;
        int currentSize = this.readBufferQueue.size();
        if (currentSize == 0) {
            this.lastByteStart = pos - partSize;
        } else {
            ReadBuffer[] readBuffers = this.readBufferQueue.toArray(new ReadBuffer[currentSize]);
            this.lastByteStart = readBuffers[currentSize - 1].getByteStart();
        }
        int maxLen = this.maxReadAheadPartNumber - currentSize;
        for (int i = 0; i < maxLen && i < (currentSize + 1) * 2 && this.lastByteStart + partSize * (long)(i + 1) <= this.contentLength; ++i) {
            ReadBuffer readBuffer;
            long byteStart = this.lastByteStart + partSize * (long)(i + 1);
            long byteEnd = byteStart + partSize - 1L;
            if (byteEnd >= this.contentLength) {
                byteEnd = this.contentLength - 1L;
            }
            if ((readBuffer = new ReadBuffer(byteStart, byteEnd)).getBuffer().length == 0) {
                readBuffer.setStatus(ReadBuffer.STATUS.SUCCESS);
            } else {
                this.readAheadExecutorService.execute(new AliyunOSSFileReaderTask(this.key, this.store, readBuffer));
            }
            this.readBufferQueue.add(readBuffer);
            if (isRandomIO) break;
        }
        ReadBuffer readBuffer = this.readBufferQueue.poll();
        readBuffer.lock();
        try {
            readBuffer.await(ReadBuffer.STATUS.INIT);
            this.buffer = (byte[])(readBuffer.getStatus() == ReadBuffer.STATUS.ERROR ? null : readBuffer.getBuffer());
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"interrupted when wait a read buffer");
        }
        finally {
            readBuffer.unlock();
        }
        if (this.buffer == null) {
            throw new IOException("Null IO stream");
        }
        this.position = pos;
        this.partRemaining = partSize;
    }

    public synchronized int read() throws IOException {
        this.checkNotClosed();
        if (this.partRemaining <= 0L && this.position < this.contentLength) {
            this.reopen(this.position);
        }
        int byteRead = -1;
        if (this.partRemaining != 0L) {
            byteRead = this.buffer[this.buffer.length - (int)this.partRemaining] & 0xFF;
        }
        if (byteRead >= 0) {
            ++this.position;
            --this.partRemaining;
        }
        if (this.statistics != null && byteRead >= 0) {
            this.statistics.incrementBytesRead((long)byteRead);
        }
        return byteRead;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.checkNotClosed();
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int bytesRead = 0;
        while (this.position < this.contentLength && bytesRead < len) {
            if (this.partRemaining == 0L) {
                this.reopen(this.position);
            }
            int bytes = 0;
            for (int i = this.buffer.length - (int)this.partRemaining; i < this.buffer.length; ++i) {
                buf[off + bytesRead] = this.buffer[i];
                ++bytes;
                if (off + ++bytesRead >= len) break;
            }
            if (bytes > 0) {
                this.position += (long)bytes;
                this.partRemaining -= (long)bytes;
                continue;
            }
            if (this.partRemaining == 0L) continue;
            throw new IOException("Failed to read from stream. Remaining:" + this.partRemaining);
        }
        if (this.statistics != null && bytesRead > 0) {
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        if (bytesRead == 0 && len > 0) {
            return -1;
        }
        return bytesRead;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.buffer = null;
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.contentLength - this.position;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    public synchronized void seek(long pos) throws IOException {
        this.checkNotClosed();
        if (this.position == pos) {
            return;
        }
        if (pos > this.position && pos < this.position + this.partRemaining) {
            long len = pos - this.position;
            this.position = pos;
            this.partRemaining -= len;
        } else {
            this.reopen(pos);
        }
    }

    public synchronized long getPos() throws IOException {
        this.checkNotClosed();
        return this.position;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.checkNotClosed();
        return false;
    }

    public long getExpectNextPos() {
        return this.expectNextPos;
    }
}

