/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
final class BlobOperationDescriptor {
    private BlobOperationDescriptor() {
    }

    private static long getContentLengthIfKnown(String range) {
        String[] offsets;
        long contentLength = 0L;
        if (range != null && range.startsWith("bytes=") && (offsets = range.substring("bytes=".length()).split("-")).length == 2) {
            contentLength = Long.parseLong(offsets[1]) - Long.parseLong(offsets[0]) + 1L;
        }
        return contentLength;
    }

    static long getContentLengthIfKnown(HttpURLConnection conn, OperationType operationType) {
        long contentLength = 0L;
        switch (operationType) {
            case AppendBlock: 
            case PutBlock: {
                String lengthString = conn.getRequestProperty("Content-Length");
                contentLength = lengthString != null ? Long.parseLong(lengthString) : 0L;
                break;
            }
            case PutPage: 
            case GetBlob: {
                contentLength = BlobOperationDescriptor.getContentLengthIfKnown(conn.getRequestProperty("x-ms-range"));
                break;
            }
        }
        return contentLength;
    }

    static OperationType getOperationType(HttpURLConnection conn) {
        OperationType operationType = OperationType.Unknown;
        String method = conn.getRequestMethod();
        String compValue = BlobOperationDescriptor.getQueryParameter(conn.getURL(), "comp");
        if (method.equalsIgnoreCase("PUT")) {
            if (compValue != null) {
                switch (compValue) {
                    case "metadata": {
                        operationType = OperationType.SetMetadata;
                        break;
                    }
                    case "properties": {
                        operationType = OperationType.SetProperties;
                        break;
                    }
                    case "block": {
                        operationType = OperationType.PutBlock;
                        break;
                    }
                    case "page": {
                        String pageWrite = conn.getRequestProperty("x-ms-page-write");
                        if (pageWrite == null || !pageWrite.equalsIgnoreCase("UPDATE")) break;
                        operationType = OperationType.PutPage;
                        break;
                    }
                    case "appendblock": {
                        operationType = OperationType.AppendBlock;
                        break;
                    }
                    case "blocklist": {
                        operationType = OperationType.PutBlockList;
                        break;
                    }
                }
            } else {
                String resType;
                String blobType = conn.getRequestProperty("x-ms-blob-type");
                if (blobType != null && (blobType.equalsIgnoreCase("PageBlob") || blobType.equalsIgnoreCase("BlockBlob") || blobType.equalsIgnoreCase("AppendBlob"))) {
                    operationType = OperationType.CreateBlob;
                } else if (blobType == null && (resType = BlobOperationDescriptor.getQueryParameter(conn.getURL(), "restype")) != null && resType.equalsIgnoreCase("container")) {
                    operationType = OperationType.CreateContainer;
                }
            }
        } else if (method.equalsIgnoreCase("GET")) {
            if (compValue != null) {
                switch (compValue) {
                    case "list": {
                        operationType = OperationType.ListBlobs;
                        break;
                    }
                    case "metadata": {
                        operationType = OperationType.GetMetadata;
                        break;
                    }
                    case "blocklist": {
                        operationType = OperationType.GetBlockList;
                        break;
                    }
                    case "pagelist": {
                        operationType = OperationType.GetPageList;
                        break;
                    }
                }
            } else if (conn.getRequestProperty("x-ms-range") != null) {
                operationType = OperationType.GetBlob;
            }
        } else if (method.equalsIgnoreCase("HEAD")) {
            operationType = OperationType.GetProperties;
        } else if (method.equalsIgnoreCase("DELETE")) {
            String resType = BlobOperationDescriptor.getQueryParameter(conn.getURL(), "restype");
            operationType = resType != null && resType.equalsIgnoreCase("container") ? OperationType.DeleteContainer : OperationType.DeleteBlob;
        }
        return operationType;
    }

    private static String getQueryParameter(URL url, String queryParameterName) {
        String query;
        String string = query = url != null ? url.getQuery() : null;
        if (query == null) {
            return null;
        }
        String searchValue = queryParameterName + "=";
        int offset = query.indexOf(searchValue);
        String value = null;
        if (offset != -1) {
            int beginIndex = offset + searchValue.length();
            int endIndex = query.indexOf(38, beginIndex);
            value = endIndex == -1 ? query.substring(beginIndex) : query.substring(beginIndex, endIndex);
        }
        return value;
    }

    @InterfaceAudience.Private
    static enum OperationType {
        AppendBlock,
        CreateBlob,
        CreateContainer,
        DeleteBlob,
        DeleteContainer,
        GetBlob,
        GetBlockList,
        GetMetadata,
        GetPageList,
        GetProperties,
        ListBlobs,
        PutBlock,
        PutBlockList,
        PutPage,
        SetMetadata,
        SetProperties,
        Unknown;

    }
}

