/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourcesInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={CapacitySchedulerLeafQueueInfo.class})
public class CapacitySchedulerQueueInfo {
    @XmlTransient
    static final float EPSILON = 1.0E-8f;
    @XmlTransient
    protected String queuePath;
    protected float capacity;
    protected float usedCapacity;
    protected float maxCapacity;
    protected float absoluteCapacity;
    protected float absoluteMaxCapacity;
    protected float absoluteUsedCapacity;
    protected int numApplications;
    protected String queueName;
    protected QueueState state;
    protected CapacitySchedulerQueueInfoList queues;
    protected ResourceInfo resourcesUsed;
    private boolean hideReservationQueues = false;
    protected ArrayList<String> nodeLabels = new ArrayList();
    protected long allocatedContainers;
    protected long reservedContainers;
    protected long pendingContainers;
    protected QueueCapacitiesInfo capacities;
    protected ResourcesInfo resources;

    CapacitySchedulerQueueInfo() {
    }

    CapacitySchedulerQueueInfo(CSQueue q) {
        Set<String> labelSet;
        this.queuePath = q.getQueuePath();
        this.capacity = q.getCapacity() * 100.0f;
        this.usedCapacity = q.getUsedCapacity() * 100.0f;
        this.maxCapacity = q.getMaximumCapacity();
        if (this.maxCapacity < 1.0E-8f || this.maxCapacity > 1.0f) {
            this.maxCapacity = 1.0f;
        }
        this.maxCapacity *= 100.0f;
        this.absoluteCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteCapacity(), 0.0f, 1.0f) * 100.0f;
        this.absoluteMaxCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteMaximumCapacity(), 0.0f, 1.0f) * 100.0f;
        this.absoluteUsedCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteUsedCapacity(), 0.0f, 1.0f) * 100.0f;
        this.numApplications = q.getNumApplications();
        this.allocatedContainers = q.getMetrics().getAllocatedContainers();
        this.pendingContainers = q.getMetrics().getPendingContainers();
        this.reservedContainers = q.getMetrics().getReservedContainers();
        this.queueName = q.getQueueName();
        this.state = q.getState();
        this.resourcesUsed = new ResourceInfo(q.getUsedResources());
        if (q instanceof PlanQueue && !((PlanQueue)q).showReservationsAsQueues()) {
            this.hideReservationQueues = true;
        }
        if ((labelSet = q.getAccessibleNodeLabels()) != null) {
            this.nodeLabels.addAll(labelSet);
            Collections.sort(this.nodeLabels);
        }
        QueueCapacities qCapacities = q.getQueueCapacities();
        this.populateQueueCapacities(qCapacities);
        ResourceUsage queueResourceUsage = q.getQueueResourceUsage();
        this.populateQueueResourceUsage(queueResourceUsage);
    }

    protected void populateQueueResourceUsage(ResourceUsage queueResourceUsage) {
        this.resources = new ResourcesInfo(queueResourceUsage, false);
    }

    protected void populateQueueCapacities(QueueCapacities qCapacities) {
        this.capacities = new QueueCapacitiesInfo(qCapacities, false);
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    public float getAbsoluteMaxCapacity() {
        return this.absoluteMaxCapacity;
    }

    public float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    public int getNumApplications() {
        return this.numApplications;
    }

    public long getAllocatedContainers() {
        return this.allocatedContainers;
    }

    public long getReservedContainers() {
        return this.reservedContainers;
    }

    public long getPendingContainers() {
        return this.pendingContainers;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getQueueState() {
        return this.state.toString();
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public CapacitySchedulerQueueInfoList getQueues() {
        if (this.hideReservationQueues) {
            return new CapacitySchedulerQueueInfoList();
        }
        return this.queues;
    }

    public ResourceInfo getResourcesUsed() {
        return this.resourcesUsed;
    }

    static float cap(float val, float low, float hi) {
        return Math.min(Math.max(val, low), hi);
    }

    public ArrayList<String> getNodeLabels() {
        return this.nodeLabels;
    }

    public QueueCapacitiesInfo getCapacities() {
        return this.capacities;
    }

    public ResourcesInfo getResources() {
        return this.resources;
    }
}

