/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public final class ZKTableStateClientSideReader {
    private ZKTableStateClientSideReader() {
    }

    public static boolean isDisabledTable(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException, TableNotFoundException {
        ZooKeeperProtos.Table.State state = ZKTableStateClientSideReader.getTableState(zkw, tableName);
        return ZKTableStateClientSideReader.isTableState(ZooKeeperProtos.Table.State.DISABLED, state);
    }

    public static boolean isEnabledTable(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException, TableNotFoundException {
        return ZKTableStateClientSideReader.getTableState(zkw, tableName) == ZooKeeperProtos.Table.State.ENABLED;
    }

    public static boolean isDisablingOrDisabledTable(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException, TableNotFoundException {
        ZooKeeperProtos.Table.State state = ZKTableStateClientSideReader.getTableState(zkw, tableName);
        return ZKTableStateClientSideReader.isTableState(ZooKeeperProtos.Table.State.DISABLING, state) || ZKTableStateClientSideReader.isTableState(ZooKeeperProtos.Table.State.DISABLED, state);
    }

    public static Set<TableName> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException, TableNotFoundException {
        HashSet<TableName> disabledTables = new HashSet<TableName>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.Table.State state = ZKTableStateClientSideReader.getTableState(zkw, tableName);
            if (state != ZooKeeperProtos.Table.State.DISABLED) continue;
            disabledTables.add(tableName);
        }
        return disabledTables;
    }

    public static Set<TableName> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException, TableNotFoundException {
        return ZKTableStateClientSideReader.getTablesInStates(zkw, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING);
    }

    public static Set<TableName> getEnablingTables(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException, TableNotFoundException {
        return ZKTableStateClientSideReader.getTablesInStates(zkw, ZooKeeperProtos.Table.State.ENABLING);
    }

    private static Set<TableName> getTablesInStates(ZooKeeperWatcher zkw, ZooKeeperProtos.Table.State ... states) throws KeeperException, InterruptedException, TableNotFoundException {
        HashSet<TableName> tableNameSet = new HashSet<TableName>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        block0: for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.Table.State tableState = ZKTableStateClientSideReader.getTableState(zkw, tableName);
            for (ZooKeeperProtos.Table.State state : states) {
                if (tableState != state) continue;
                tableNameSet.add(tableName);
                continue block0;
            }
        }
        return tableNameSet;
    }

    static boolean isTableState(ZooKeeperProtos.Table.State expectedState, ZooKeeperProtos.Table.State currentState) {
        return currentState != null && currentState.equals((Object)expectedState);
    }

    static ZooKeeperProtos.Table.State getTableState(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException, TableNotFoundException {
        String znode = ZKUtil.joinZNode(zkw.tableZNode, tableName.getNameAsString());
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            throw new TableNotFoundException(tableName);
        }
        try {
            ProtobufUtil.expectPBMagicPrefix(data);
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, data, magicLen, data.length - magicLen);
            return builder.getState();
        }
        catch (IOException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }
}

