/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.block.SecurityTestUtil;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestBlockTokenWithDFS {
    protected static int BLOCK_SIZE = 1024;
    protected static int FILE_SIZE = 2 * BLOCK_SIZE;
    private static final String FILE_TO_READ = "/fileToRead.dat";
    private static final String FILE_TO_WRITE = "/fileToWrite.dat";
    private static final String FILE_TO_APPEND = "/fileToAppend.dat";

    public TestBlockTokenWithDFS() {
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
    }

    public static byte[] generateBytes(int fileSize) {
        Random r = new Random();
        byte[] rawData = new byte[fileSize];
        r.nextBytes(rawData);
        return rawData;
    }

    private void createFile(FileSystem fs, Path filename, byte[] expected) throws IOException {
        FSDataOutputStream out = fs.create(filename);
        out.write(expected);
        out.close();
    }

    private boolean checkFile1(FSDataInputStream in, byte[] expected) {
        byte[] toRead = new byte[expected.length];
        int totalRead = 0;
        int nRead = 0;
        try {
            while ((nRead = in.read(toRead, totalRead, toRead.length - totalRead)) > 0) {
                totalRead += nRead;
            }
        }
        catch (IOException e) {
            return false;
        }
        Assert.assertEquals((String)"Cannot read file.", (long)toRead.length, (long)totalRead);
        return this.checkFile(toRead, expected);
    }

    private boolean checkFile2(FSDataInputStream in, byte[] expected) {
        byte[] toRead = new byte[expected.length];
        try {
            Assert.assertEquals((String)"Cannot read file", (long)toRead.length, (long)in.read(0L, toRead, 0, toRead.length));
        }
        catch (IOException e) {
            return false;
        }
        return this.checkFile(toRead, expected);
    }

    private boolean checkFile(byte[] fileToCheck, byte[] expected) {
        if (fileToCheck.length != expected.length) {
            return false;
        }
        for (int i = 0; i < fileToCheck.length; ++i) {
            if (fileToCheck[i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private static FSDataOutputStream writeFile(FileSystem fileSys, Path name, short repl, long blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), repl, blockSize);
        return stm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryRead(final Configuration conf, LocatedBlock lblock, boolean shouldSucceed) {
        InetSocketAddress targetAddr = null;
        IOException ioe = null;
        BlockReader blockReader = null;
        ExtendedBlock block = lblock.getBlock();
        try {
            DatanodeInfoWithStorage[] nodes = lblock.getLocations();
            targetAddr = NetUtils.createSocketAddr((String)nodes[0].getXferAddr());
            blockReader = new BlockReaderFactory(new DfsClientConf(conf)).setFileName(BlockReaderFactory.getFileName((InetSocketAddress)targetAddr, (String)"test-blockpoolid", (long)block.getBlockId())).setBlock(block).setBlockToken(lblock.getBlockToken()).setInetSocketAddress(targetAddr).setStartOffset(0L).setLength(0L).setVerifyChecksum(true).setClientName("TestBlockTokenWithDFS").setDatanodeInfo((DatanodeInfo)nodes[0]).setCachingStrategy(CachingStrategy.newDefaultStrategy()).setClientCacheContext(ClientContext.getFromConf((Configuration)conf)).setConfiguration(conf).setRemotePeerFactory(new RemotePeerFactory(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
                    Peer peer = null;
                    Socket sock = NetUtils.getDefaultSocketFactory((Configuration)conf).createSocket();
                    try {
                        sock.connect(addr, 60000);
                        sock.setSoTimeout(60000);
                        peer = DFSUtilClient.peerFromSocket((Socket)sock);
                    }
                    finally {
                        if (peer == null) {
                            IOUtils.closeSocket((Socket)sock);
                        }
                    }
                    return peer;
                }
            }).build();
        }
        catch (IOException ex) {
            ioe = ex;
        }
        finally {
            if (blockReader != null) {
                try {
                    blockReader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (shouldSucceed) {
            Assert.assertNotNull((String)"OP_READ_BLOCK: access token is invalid, when it is expected to be valid", blockReader);
        } else {
            Assert.assertNotNull((String)"OP_READ_BLOCK: access token is valid, when it is expected to be invalid", (Object)ioe);
            Assert.assertTrue((String)"OP_READ_BLOCK failed due to reasons other than access token: ", (boolean)(ioe instanceof InvalidBlockTokenException));
        }
    }

    protected Configuration getConf(int numDataNodes) {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setLong("dfs.blocksize", (long)BLOCK_SIZE);
        conf.setInt("io.bytes.per.checksum", BLOCK_SIZE);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.replication", numDataNodes);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setInt("dfs.client.retry.window.base", 10);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        Configuration conf = this.getConf(numDataNodes);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            Assert.assertEquals((long)numDataNodes, (long)cluster.getDataNodes().size());
            NameNode nn = cluster.getNameNode();
            BlockManager bm = nn.getNamesystem().getBlockManager();
            BlockTokenSecretManager sm = bm.getBlockTokenSecretManager();
            SecurityTestUtil.setBlockTokenLifetime(sm, 1000L);
            Path fileToAppend = new Path(FILE_TO_APPEND);
            DistributedFileSystem fs = cluster.getFileSystem();
            byte[] expected = TestBlockTokenWithDFS.generateBytes(FILE_SIZE);
            FSDataOutputStream stm = TestBlockTokenWithDFS.writeFile((FileSystem)fs, fileToAppend, (short)numDataNodes, BLOCK_SIZE);
            stm.write(expected, 0, 1);
            stm.close();
            stm = fs.append(fileToAppend);
            int mid = expected.length - 1;
            stm.write(expected, 1, mid - 1);
            stm.hflush();
            Token<BlockTokenIdentifier> token = DFSTestUtil.getBlockToken(stm);
            while (!SecurityTestUtil.isBlockTokenExpired(token)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            cluster.stopDataNode(0);
            stm.write(expected, mid, expected.length - mid);
            stm.close();
            FSDataInputStream in5 = fs.open(fileToAppend);
            Assert.assertTrue((boolean)this.checkFile1(in5, expected));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrite() throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        Configuration conf = this.getConf(numDataNodes);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            Assert.assertEquals((long)numDataNodes, (long)cluster.getDataNodes().size());
            NameNode nn = cluster.getNameNode();
            BlockManager bm = nn.getNamesystem().getBlockManager();
            BlockTokenSecretManager sm = bm.getBlockTokenSecretManager();
            SecurityTestUtil.setBlockTokenLifetime(sm, 1000L);
            Path fileToWrite = new Path(FILE_TO_WRITE);
            DistributedFileSystem fs = cluster.getFileSystem();
            byte[] expected = TestBlockTokenWithDFS.generateBytes(FILE_SIZE);
            FSDataOutputStream stm = TestBlockTokenWithDFS.writeFile((FileSystem)fs, fileToWrite, (short)numDataNodes, BLOCK_SIZE);
            int mid = expected.length - 1;
            stm.write(expected, 0, mid);
            stm.hflush();
            Token<BlockTokenIdentifier> token = DFSTestUtil.getBlockToken(stm);
            while (!SecurityTestUtil.isBlockTokenExpired(token)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            cluster.stopDataNode(0);
            stm.write(expected, mid, expected.length - mid);
            stm.close();
            FSDataInputStream in4 = fs.open(fileToWrite);
            Assert.assertTrue((boolean)this.checkFile1(in4, expected));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRead() throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        Configuration conf = this.getConf(numDataNodes);
        try {
            cluster = new MiniDFSCluster.Builder(conf).nameNodePort(ServerSocketUtil.getPort((int)18020, (int)100)).nameNodeHttpPort(ServerSocketUtil.getPort((int)19870, (int)100)).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            Assert.assertEquals((long)numDataNodes, (long)cluster.getDataNodes().size());
            this.doTestRead(conf, cluster, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestRead(Configuration conf, MiniDFSCluster cluster, boolean isStriped) throws Exception {
        int numDataNodes = cluster.getDataNodes().size();
        NameNode nn = cluster.getNameNode();
        NamenodeProtocols nnProto = nn.getRpcServer();
        BlockManager bm = nn.getNamesystem().getBlockManager();
        BlockTokenSecretManager sm = bm.getBlockTokenSecretManager();
        SecurityTestUtil.setBlockTokenLifetime(sm, 1000L);
        Path fileToRead = new Path(FILE_TO_READ);
        DistributedFileSystem fs = cluster.getFileSystem();
        byte[] expected = TestBlockTokenWithDFS.generateBytes(FILE_SIZE);
        this.createFile((FileSystem)fs, fileToRead, expected);
        FSDataInputStream in1 = fs.open(fileToRead);
        Assert.assertTrue((boolean)this.checkFile1(in1, expected));
        FSDataInputStream in2 = fs.open(fileToRead);
        Assert.assertTrue((boolean)this.checkFile1(in2, expected));
        FSDataInputStream in3 = fs.open(fileToRead);
        Assert.assertTrue((boolean)this.checkFile2(in3, expected));
        try (DFSClient client = null;){
            client = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
        }
        List locatedBlocks = nnProto.getBlockLocations(FILE_TO_READ, 0L, (long)FILE_SIZE).getLocatedBlocks();
        LocatedBlock lblock = (LocatedBlock)locatedBlocks.get(0);
        Assert.assertFalse((boolean)this.isBlockTokenExpired(lblock));
        this.tryRead(conf, lblock, true);
        while (!this.isBlockTokenExpired(lblock)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertTrue((boolean)this.isBlockTokenExpired(lblock));
        this.tryRead(conf, lblock, false);
        bm.setBlockToken(lblock, BlockTokenIdentifier.AccessMode.READ);
        this.tryRead(conf, lblock, true);
        long rightId = lblock.getBlock().getBlockId();
        long wrongId = rightId + 1L;
        lblock.getBlock().setBlockId(wrongId);
        bm.setBlockToken(lblock, BlockTokenIdentifier.AccessMode.READ);
        lblock.getBlock().setBlockId(rightId);
        this.tryRead(conf, lblock, false);
        bm.setBlockToken(lblock, BlockTokenIdentifier.AccessMode.WRITE);
        this.tryRead(conf, lblock, false);
        SecurityTestUtil.setBlockTokenLifetime(sm, 600000L);
        List<LocatedBlock> lblocks = DFSTestUtil.getAllBlocks(in1);
        for (LocatedBlock locatedBlock : lblocks) {
            Assert.assertTrue((boolean)this.isBlockTokenExpired(locatedBlock));
        }
        in1.seek(0L);
        Assert.assertTrue((boolean)this.checkFile1(in1, expected));
        List<LocatedBlock> lblocks2 = DFSTestUtil.getAllBlocks(in2);
        for (LocatedBlock blk : lblocks2) {
            Assert.assertTrue((boolean)this.isBlockTokenExpired(blk));
        }
        if (isStriped) {
            in2.seek(0L);
        } else {
            Assert.assertTrue((boolean)in2.seekToNewSource(0L));
        }
        Assert.assertTrue((boolean)this.checkFile1(in2, expected));
        List<LocatedBlock> list = DFSTestUtil.getAllBlocks(in3);
        for (LocatedBlock blk : list) {
            Assert.assertTrue((boolean)this.isBlockTokenExpired(blk));
        }
        Assert.assertTrue((boolean)this.checkFile2(in3, expected));
        Assert.assertTrue((boolean)cluster.restartDataNodes(true));
        cluster.waitActive();
        Assert.assertEquals((long)numDataNodes, (long)cluster.getDataNodes().size());
        cluster.shutdownNameNode(0);
        lblocks = DFSTestUtil.getAllBlocks(in1);
        for (LocatedBlock blk : lblocks) {
            Assert.assertFalse((boolean)this.isBlockTokenExpired(blk));
        }
        in1.seek(0L);
        Assert.assertTrue((boolean)this.checkFile1(in1, expected));
        lblocks2 = DFSTestUtil.getAllBlocks(in2);
        for (LocatedBlock blk : lblocks2) {
            Assert.assertFalse((boolean)this.isBlockTokenExpired(blk));
        }
        if (isStriped) {
            in2.seek(0L);
        } else {
            in2.seekToNewSource(0L);
        }
        Assert.assertTrue((boolean)this.checkFile1(in2, expected));
        List<LocatedBlock> list2 = DFSTestUtil.getAllBlocks(in3);
        for (LocatedBlock blk : list2) {
            Assert.assertFalse((boolean)this.isBlockTokenExpired(blk));
        }
        Assert.assertTrue((boolean)this.checkFile2(in3, expected));
        cluster.restartNameNode(0);
        cluster.shutdownNameNode(0);
        in1.seek(0L);
        Assert.assertTrue((boolean)this.checkFile1(in1, expected));
        if (isStriped) {
            in2.seek(0L);
        } else {
            in2.seekToNewSource(0L);
        }
        Assert.assertTrue((boolean)this.checkFile1(in2, expected));
        Assert.assertTrue((boolean)this.checkFile2(in3, expected));
        cluster.restartNameNode(0);
        Assert.assertTrue((boolean)cluster.restartDataNodes(true));
        cluster.waitActive();
        Assert.assertEquals((long)numDataNodes, (long)cluster.getDataNodes().size());
        cluster.shutdownNameNode(0);
        in1.seek(0L);
        Assert.assertFalse((boolean)this.checkFile1(in1, expected));
        Assert.assertFalse((boolean)this.checkFile2(in3, expected));
        cluster.restartNameNode(0);
        in1.seek(0L);
        Assert.assertTrue((boolean)this.checkFile1(in1, expected));
        if (isStriped) {
            in2.seek(0L);
        } else {
            in2.seekToNewSource(0L);
        }
        Assert.assertTrue((boolean)this.checkFile1(in2, expected));
        Assert.assertTrue((boolean)this.checkFile2(in3, expected));
        Assert.assertTrue((boolean)cluster.restartDataNodes(false));
        cluster.waitActive();
        Assert.assertEquals((long)numDataNodes, (long)cluster.getDataNodes().size());
        in1.seek(0L);
        Assert.assertTrue((boolean)this.checkFile1(in1, expected));
        if (isStriped) {
            in2.seek(0L);
        } else {
            in2.seekToNewSource(0L);
        }
        Assert.assertTrue((boolean)this.checkFile1(in2, expected));
        Assert.assertTrue((boolean)this.checkFile2(in3, expected));
    }

    @Test
    public void testEnd2End() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        new TestBalancer().integrationTest(conf);
    }

    protected boolean isBlockTokenExpired(LocatedBlock lb) throws IOException {
        return SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)lb.getBlockToken());
    }
}

