/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.IterativePlanner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocatorGreedyRLE;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageExecutionIntervalUnconstrained;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyReservationAgent
implements ReservationAgent {
    private static final Logger LOG = LoggerFactory.getLogger(GreedyReservationAgent.class);
    private ReservationAgent planner;
    private boolean allocateLeft;

    @Override
    public void init(Configuration conf) {
        this.allocateLeft = conf.getBoolean("yarn.resourcemanager.reservation-system.favor-early-allocation", true);
        if (this.allocateLeft) {
            LOG.info("Initializing the GreedyReservationAgent to favor \"early\" (left) allocations (controlled by parameter: yarn.resourcemanager.reservation-system.favor-early-allocation)");
        } else {
            LOG.info("Initializing the GreedyReservationAgent to favor \"late\" (right) allocations (controlled by parameter: yarn.resourcemanager.reservation-system.favor-early-allocation)");
        }
        this.planner = new IterativePlanner(new StageExecutionIntervalUnconstrained(), new StageAllocatorGreedyRLE(this.allocateLeft), this.allocateLeft);
    }

    public boolean isAllocateLeft() {
        return this.allocateLeft;
    }

    @Override
    public boolean createReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        LOG.info("placing the following ReservationRequest: " + contract);
        try {
            boolean res = this.planner.createReservation(reservationId, user, plan, contract);
            if (res) {
                LOG.info("OUTCOME: SUCCESS, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            } else {
                LOG.info("OUTCOME: FAILURE, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            }
            return res;
        }
        catch (PlanningException e) {
            LOG.info("OUTCOME: FAILURE, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            throw e;
        }
    }

    @Override
    public boolean updateReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        LOG.info("updating the following ReservationRequest: " + contract);
        return this.planner.updateReservation(reservationId, user, plan, contract);
    }

    @Override
    public boolean deleteReservation(ReservationId reservationId, String user, Plan plan) throws PlanningException {
        LOG.info("removing the following ReservationId: " + reservationId);
        return this.planner.deleteReservation(reservationId, user, plan);
    }
}

