/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.adapter;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.adapter.V1ToV2AwsCredentialProviderAdapter;
import org.apache.hadoop.fs.s3a.impl.InstantiationIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public final class AwsV1BindingSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AwsV1BindingSupport.class);
    public static final String CREDENTIAL_PROVIDER_CLASSNAME = "com.amazonaws.auth.AWSCredentialsProvider";
    private static final boolean SDK_V1_FOUND = AwsV1BindingSupport.checkForAwsV1Sdk();

    private AwsV1BindingSupport() {
    }

    private static boolean checkForAwsV1Sdk() {
        try {
            ClassLoader cl = AwsV1BindingSupport.class.getClassLoader();
            cl.loadClass(CREDENTIAL_PROVIDER_CLASSNAME);
            LOG.debug("v1 SDK class {} found", (Object)CREDENTIAL_PROVIDER_CLASSNAME);
            return true;
        }
        catch (Exception e) {
            LOG.debug("v1 SDK class {} not found", (Object)CREDENTIAL_PROVIDER_CLASSNAME, (Object)e);
            return false;
        }
    }

    public static synchronized boolean isAwsV1SdkAvailable() {
        return SDK_V1_FOUND;
    }

    public static AwsCredentialsProvider createAWSV1CredentialProvider(Configuration conf, String className, @Nullable URI uri, String key) throws IOException {
        if (!AwsV1BindingSupport.isAwsV1SdkAvailable()) {
            throw InstantiationIOException.unavailable(uri, className, key, "No AWS v1 SDK available");
        }
        return V1ToV2AwsCredentialProviderAdapter.create(conf, className, uri);
    }
}

