/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import org.wildfly.openssl.OpenSSLSessionContext;
import org.wildfly.openssl.SSL;

public final class OpenSSLServerSessionContext
extends OpenSSLSessionContext {
    OpenSSLServerSessionContext(long context) {
        super(context);
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        SSL.getInstance().setSessionCacheTimeout(this.context, seconds);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSL.getInstance().getSessionCacheTimeout(this.context);
    }

    @Override
    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        SSL.getInstance().setSessionCacheSize(this.context, size);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)SSL.getInstance().getSessionCacheSize(this.context);
    }

    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? 2L : 0L;
        SSL.getInstance().setSessionCacheMode(this.context, mode);
    }

    public boolean isSessionCacheEnabled() {
        return SSL.getInstance().getSessionCacheMode(this.context) == 2L;
    }

    public boolean setSessionIdContext(byte[] sidCtx) {
        return SSL.getInstance().setSessionIdContext(this.context, sidCtx);
    }
}

