/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;

@InterfaceAudience.Private
public final class AzureFileSystemMetricsSystem {
    private static MetricsSystemImpl instance;
    private static int numFileSystems;

    private AzureFileSystemMetricsSystem() {
    }

    public static synchronized void fileSystemStarted() {
        if (numFileSystems == 0) {
            instance = new MetricsSystemImpl();
            instance.init("azure-file-system");
        }
        ++numFileSystems;
    }

    public static synchronized void fileSystemClosed() {
        if (numFileSystems == 1) {
            instance.publishMetricsNow();
            instance.stop();
            instance.shutdown();
            instance = null;
        }
        --numFileSystems;
    }

    public static void registerSource(String name, String desc, MetricsSource source) {
        instance.register(name, desc, (Object)source);
    }

    public static synchronized void unregisterSource(String name) {
        if (instance != null) {
            instance.publishMetricsNow();
            instance.unregisterSource(name);
        }
    }
}

