/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class OffsetAndMetadata
implements Serializable {
    private static final long serialVersionUID = 2019555404968089681L;
    private final long offset;
    private final String metadata;
    private final Integer leaderEpoch;

    public OffsetAndMetadata(long offset, Optional<Integer> leaderEpoch, String metadata) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        this.offset = offset;
        this.leaderEpoch = leaderEpoch.orElse(null);
        this.metadata = metadata == null ? "" : metadata;
    }

    public OffsetAndMetadata(long offset, String metadata) {
        this(offset, Optional.empty(), metadata);
    }

    public OffsetAndMetadata(long offset) {
        this(offset, "");
    }

    public long offset() {
        return this.offset;
    }

    public String metadata() {
        return this.metadata;
    }

    public Optional<Integer> leaderEpoch() {
        if (this.leaderEpoch == null || this.leaderEpoch < 0) {
            return Optional.empty();
        }
        return Optional.of(this.leaderEpoch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetAndMetadata that = (OffsetAndMetadata)o;
        return this.offset == that.offset && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.leaderEpoch, that.leaderEpoch);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.metadata, this.leaderEpoch);
    }

    public String toString() {
        return "OffsetAndMetadata{offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ", metadata='" + this.metadata + '\'' + '}';
    }
}

