/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestUTF8 {
    private static final Random RANDOM = new Random();

    public static String getTestString() throws Exception {
        StringBuilder buffer = new StringBuilder();
        int length = RANDOM.nextInt(100);
        for (int i = 0; i < length; ++i) {
            buffer.append((char)RANDOM.nextInt(65535));
        }
        return buffer.toString();
    }

    @Test
    public void testWritable() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            TestWritable.testWritable((Writable)new UTF8(TestUTF8.getTestString()));
        }
    }

    @Test
    public void testGetBytes() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            String before = TestUTF8.getTestString();
            Assert.assertEquals((Object)before, (Object)this.readModifiedUTF(UTF8.getBytes((String)before)));
        }
    }

    private String readModifiedUTF(byte[] bytes) throws IOException {
        int lengthBytes = 2;
        ByteBuffer bb = ByteBuffer.allocate(bytes.length + 2);
        bb.putShort((short)bytes.length).put(bytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(bb.array());
        DataInputStream dis = new DataInputStream(bis);
        return dis.readUTF();
    }

    @Test
    public void testIO() throws Exception {
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        for (int i = 0; i < 10000; ++i) {
            String before = TestUTF8.getTestString();
            out.reset();
            UTF8.writeString((DataOutput)out, (String)before);
            in.reset(out.getData(), out.getLength());
            String after = UTF8.readString((DataInput)in);
            Assert.assertEquals((Object)before, (Object)after);
            in.reset(out.getData(), out.getLength());
            String after2 = in.readUTF();
            Assert.assertEquals((Object)before, (Object)after2);
        }
    }

    @Test
    public void testNullEncoding() throws Exception {
        String s = new String(new char[]{'\u0000'});
        DataOutputBuffer dob = new DataOutputBuffer();
        new UTF8(s).write((DataOutput)dob);
        Assert.assertEquals((Object)s, (Object)new String(dob.getData(), 2, dob.getLength() - 2, StandardCharsets.UTF_8));
    }

    @Test
    public void testNonBasicMultilingualPlane() throws Exception {
        String catFace = "\ud83d\udc31";
        byte[] encoded = catFace.getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((long)4L, (long)encoded.length);
        Assert.assertEquals((Object)"f09f90b1", (Object)StringUtils.byteToHexString((byte[])encoded));
        String roundTrip = UTF8.fromBytes((byte[])encoded);
        Assert.assertEquals((Object)catFace, (Object)roundTrip);
    }

    @Test
    public void testInvalidUTF8() throws Exception {
        byte[] invalid = new byte[]{1, 2, -1, -1, 1, 2, 3, 4, 5};
        try {
            UTF8.fromBytes((byte[])invalid);
            Assert.fail((String)"did not throw an exception");
        }
        catch (UTFDataFormatException utfde) {
            GenericTestUtils.assertExceptionContains("Invalid UTF8 at ffff01020304", utfde);
        }
    }

    @Test
    public void test5ByteUtf8Sequence() throws Exception {
        byte[] invalid = new byte[]{1, 2, -8, -120, -128, -128, -128, 4, 5};
        try {
            UTF8.fromBytes((byte[])invalid);
            Assert.fail((String)"did not throw an exception");
        }
        catch (UTFDataFormatException utfde) {
            GenericTestUtils.assertExceptionContains("Invalid UTF8 at f88880808004", utfde);
        }
    }

    @Test
    public void testInvalidUTF8Truncated() throws Exception {
        byte[] truncated = new byte[]{-16, -97, -112};
        try {
            UTF8.fromBytes((byte[])truncated);
            Assert.fail((String)"did not throw an exception");
        }
        catch (UTFDataFormatException utfde) {
            GenericTestUtils.assertExceptionContains("Truncated UTF8 at f09f90", utfde);
        }
    }
}

