/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreZooKeeperImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRouterHeartbeatService {
    private Router router;
    private final String routerId = "router1";
    private TestingServer testingServer;
    private CuratorFramework curatorFramework;

    @Before
    public void setup() throws Exception {
        this.router = new Router();
        this.router.setRouterId("router1");
        Configuration conf = new Configuration();
        conf.setInt("dfs.federation.router.cache.ttl", 1);
        Configuration routerConfig = new RouterConfigBuilder(conf).stateStore().build();
        routerConfig.setLong("dfs.federation.router.store.connection.test", TimeUnit.HOURS.toMillis(1L));
        routerConfig.setClass("dfs.federation.router.store.driver.class", StateStoreZooKeeperImpl.class, StateStoreDriver.class);
        this.testingServer = new TestingServer();
        String connectStr = this.testingServer.getConnectString();
        this.curatorFramework = CuratorFrameworkFactory.builder().connectString(connectStr).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        this.curatorFramework.start();
        routerConfig.set("hadoop.zk.address", connectStr);
        this.router.init(routerConfig);
        this.router.start();
        FederationStateStoreTestUtils.waitStateStore(this.router.getStateStore(), TimeUnit.SECONDS.toMicros(10L));
    }

    @Test
    public void testStateStoreUnavailable() throws IOException {
        this.curatorFramework.close();
        this.testingServer.stop();
        this.router.getStateStore().stop();
        Assert.assertFalse((boolean)this.router.getStateStore().isDriverReady());
        RouterHeartbeatService heartbeatService = new RouterHeartbeatService(this.router);
        heartbeatService.updateStateStore();
    }

    @Test
    public void testStateStoreAvailable() throws Exception {
        StateStoreService stateStore = this.router.getStateStore();
        Assert.assertTrue((boolean)this.router.getStateStore().isDriverReady());
        RouterStore routerStore = this.router.getRouterStateManager();
        stateStore.refreshCaches(true);
        GetRouterRegistrationRequest request = GetRouterRegistrationRequest.newInstance((String)"router1");
        GetRouterRegistrationResponse response = this.router.getRouterStateManager().getRouterRegistration(request);
        RouterState routerState = response.getRouter();
        String id = routerState.getRouterId();
        StateStoreVersion version = routerState.getStateStoreVersion();
        Assert.assertNull((Object)id);
        Assert.assertNull((Object)version);
        RouterHeartbeatService heartbeatService = new RouterHeartbeatService(this.router);
        heartbeatService.updateStateStore();
        stateStore.refreshCaches(true);
        request = GetRouterRegistrationRequest.newInstance((String)"router1");
        response = routerStore.getRouterRegistration(request);
        routerState = response.getRouter();
        id = routerState.getRouterId();
        version = routerState.getStateStoreVersion();
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)version);
    }

    @After
    public void tearDown() throws IOException {
        if (this.curatorFramework != null) {
            this.curatorFramework.close();
        }
        if (this.testingServer != null) {
            this.testingServer.stop();
        }
        if (this.router != null) {
            this.router.shutDown();
        }
    }
}

