/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.FSXAttrBaseTest;

public class TestFileContextXAttr
extends FSXAttrBaseTest {
    @Override
    protected FileSystem createFileSystem() throws Exception {
        FileContextFS fcFs = new FileContextFS();
        fcFs.initialize(FileSystem.getDefaultUri((Configuration)conf), conf);
        return fcFs;
    }

    public static class FileContextFS
    extends DistributedFileSystem {
        private FileContext fc;

        public void initialize(URI uri, Configuration conf) throws IOException {
            super.initialize(uri, conf);
            this.fc = FileContext.getFileContext((Configuration)conf);
        }

        public void setXAttr(Path path, String name, byte[] value) throws IOException {
            this.fc.setXAttr(path, name, value);
        }

        public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
            this.fc.setXAttr(path, name, value, flag);
        }

        public byte[] getXAttr(Path path, String name) throws IOException {
            return this.fc.getXAttr(path, name);
        }

        public Map<String, byte[]> getXAttrs(Path path) throws IOException {
            return this.fc.getXAttrs(path);
        }

        public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
            return this.fc.getXAttrs(path, names);
        }

        public void removeXAttr(Path path, String name) throws IOException {
            this.fc.removeXAttr(path, name);
        }
    }
}

