/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.internal.query.QueryInfo;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.AggregateDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.TopDocumentQueryExecutionContext;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import rx.Observable;

public class PipelinedDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private int actualPageSize;
    private UUID correlatedActivityId;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, UUID correlatedActivityId) {
        this.component = component;
        this.actualPageSize = actualPageSize;
        this.correlatedActivityId = correlatedActivityId;
    }

    public static <T extends Resource> Observable<PipelinedDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec expression, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        Function<String, Observable> createBaseComponentFunction = queryInfo.hasOrderBy() ? continuationToken -> {
            FeedOptions orderByFeedOptions = new FeedOptions(feedOptions);
            orderByFeedOptions.setRequestContinuation(continuationToken);
            return OrderByDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, orderByFeedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        } : continuationToken -> {
            FeedOptions parallelFeedOptions = new FeedOptions(feedOptions);
            parallelFeedOptions.setRequestContinuation(continuationToken);
            return ParallelDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, parallelFeedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        };
        Function<String, Observable> createAggregateComponentFunction = queryInfo.hasAggregates() ? continuationToken -> AggregateDocumentQueryExecutionContext.createAsync(createBaseComponentFunction, queryInfo.getAggregates(), continuationToken) : createBaseComponentFunction;
        Function<String, Observable> createTopComponentFunction = queryInfo.hasTop() ? continuationToken -> TopDocumentQueryExecutionContext.createAsync(createAggregateComponentFunction, queryInfo.getTop(), continuationToken) : createAggregateComponentFunction;
        int actualPageSize = Utils.getValueOrDefault((Integer)feedOptions.getMaxItemCount(), (int)100);
        if (actualPageSize == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault((Integer)queryInfo.getTop(), (int)actualPageSize));
        return createTopComponentFunction.apply(feedOptions.getRequestContinuation()).map(c -> new PipelinedDocumentQueryExecutionContext(c, pageSize, correlatedActivityId));
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }
}

