/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.webapp;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GlobalPolicyGenerator;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class GPGPoliciesBlock
extends HtmlBlock {
    private final GlobalPolicyGenerator gpg;
    private final FederationStateStoreFacade facade;

    @Inject
    GPGPoliciesBlock(GlobalPolicyGenerator gpg, View.ViewContext ctx) {
        super(ctx);
        this.gpg = gpg;
        this.facade = FederationStateStoreFacade.getInstance((Configuration)gpg.getConfig());
    }

    protected void render(HtmlBlock.Block html) {
        try {
            Collection<SubClusterPolicyConfiguration> policies = this.facade.getPoliciesConfigurations().values();
            this.initYarnFederationPolicies(policies, html);
        }
        catch (Exception e) {
            LOG.error("Get GPGPolicies Error.", (Throwable)e);
        }
    }

    private void initYarnFederationPolicies(Collection<SubClusterPolicyConfiguration> policies, HtmlBlock.Block html) throws FederationPolicyInitializationException {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#policies").thead().tr().th(".queue", "Queue Name").th(".policyType", "Policy Type").th(".routerPolicyWeights", "Router PolicyWeights").th(".amrmPolicyWeights", "Router AMRMPolicyWeights").th(".headroomAlpha", "Router Headroom Alpha").__()).__()).tbody();
        if (policies != null) {
            for (SubClusterPolicyConfiguration policy : policies) {
                Hamlet.TR row = tbody.tr().td(policy.getQueue());
                String type = policy.getType();
                row = row.td(type);
                ByteBuffer params = policy.getParams();
                WeightedPolicyInfo weightedPolicyInfo = WeightedPolicyInfo.fromByteBuffer((ByteBuffer)params);
                row = row.td(this.policyWeight2String(weightedPolicyInfo.getRouterPolicyWeights()));
                row = row.td(this.policyWeight2String(weightedPolicyInfo.getAMRMPolicyWeights()));
                row.td(String.valueOf(weightedPolicyInfo.getHeadroomAlpha())).__();
            }
        }
        ((Hamlet.TABLE)tbody.__()).__();
    }

    private String policyWeight2String(Map<SubClusterIdInfo, Float> weights) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<SubClusterIdInfo, Float> entry : weights.entrySet()) {
            sb.append(entry.getKey().toId()).append(": ").append(entry.getValue()).append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }
}

