/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.ServiceUnavailableException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Time;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDNS {
    private static final Logger LOG = LoggerFactory.getLogger(TestDNS.class);
    private static final String DEFAULT = "default";
    private static final String DUMMY_HOSTNAME = "-DUMMY_HOSTNAME";
    private static final String INVALID_DNS_SERVER = "0.0.0.0";

    @Test
    public void testGetLocalHost() throws Exception {
        String hostname = DNS.getDefaultHost((String)DEFAULT);
        Assert.assertNotNull((Object)hostname);
    }

    @Test
    public void testGetLocalHostIsFast() throws Exception {
        String hostname1 = DNS.getDefaultHost((String)DEFAULT);
        Assert.assertNotNull((Object)hostname1);
        String hostname2 = DNS.getDefaultHost((String)DEFAULT);
        long t1 = Time.now();
        String hostname3 = DNS.getDefaultHost((String)DEFAULT);
        long t2 = Time.now();
        Assert.assertEquals((Object)hostname3, (Object)hostname2);
        Assert.assertEquals((Object)hostname2, (Object)hostname1);
        long interval = t2 - t1;
        Assert.assertTrue((String)"Took too long to determine local host - caching is not working", (interval < 20000L ? 1 : 0) != 0);
    }

    @Test
    public void testLocalHostHasAnAddress() throws Exception {
        Assert.assertNotNull((Object)this.getLocalIPAddr());
    }

    private InetAddress getLocalIPAddr() throws UnknownHostException {
        String hostname = DNS.getDefaultHost((String)DEFAULT);
        InetAddress localhost = InetAddress.getByName(hostname);
        return localhost;
    }

    @Test
    public void testNullInterface() throws Exception {
        String host = DNS.getDefaultHost(null);
        Assertions.assertThat((String)host).isEqualTo((Object)DNS.getDefaultHost((String)DEFAULT));
        try {
            String ip = DNS.getDefaultIP(null);
            Assert.fail((String)("Expected a NullPointerException, got " + ip));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNullDnsServer() throws Exception {
        String host = DNS.getDefaultHost((String)this.getLoopbackInterface(), null);
        Assertions.assertThat((String)host).isEqualTo((Object)DNS.getDefaultHost((String)this.getLoopbackInterface()));
    }

    @Test
    public void testDefaultDnsServer() throws Exception {
        String host = DNS.getDefaultHost((String)this.getLoopbackInterface(), (String)DEFAULT);
        Assertions.assertThat((String)host).isEqualTo((Object)DNS.getDefaultHost((String)this.getLoopbackInterface()));
    }

    @Test
    public void testIPsOfUnknownInterface() throws Exception {
        try {
            DNS.getIPs((String)"name-of-an-unknown-interface");
            Assert.fail((String)"Got an IP for a bogus interface");
        }
        catch (UnknownHostException e) {
            Assert.assertEquals((Object)"No such interface name-of-an-unknown-interface", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetIPWithDefault() throws Exception {
        String[] ips = DNS.getIPs((String)DEFAULT);
        Assert.assertEquals((String)"Should only return 1 default IP", (long)1L, (long)ips.length);
        Assert.assertEquals((Object)this.getLocalIPAddr().getHostAddress(), (Object)ips[0].toString());
        String ip = DNS.getDefaultIP((String)DEFAULT);
        Assert.assertEquals((Object)ip, (Object)ips[0].toString());
    }

    @Test
    public void testRDNS() throws Exception {
        InetAddress localhost = this.getLocalIPAddr();
        try {
            String s = DNS.reverseDns((InetAddress)localhost, null);
            LOG.info("Local reverse DNS hostname is " + s);
        }
        catch (CommunicationException | NameNotFoundException | ServiceUnavailableException e) {
            if (!localhost.isLinkLocalAddress() || localhost.isLoopbackAddress()) {
                LOG.info("Reverse DNS failing as due to incomplete networking", (Throwable)e);
                LOG.info("Address is " + localhost + " Loopback=" + localhost.isLoopbackAddress() + " Linklocal=" + localhost.isLinkLocalAddress());
            }
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test(timeout=60000L)
    public void testLookupWithHostsFallback() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String oldHostname = DNS.getCachedHostname();
        try {
            DNS.setCachedHostname((String)DUMMY_HOSTNAME);
            String hostname = DNS.getDefaultHost((String)this.getLoopbackInterface(), (String)INVALID_DNS_SERVER, (boolean)true);
            Assertions.assertThat((String)hostname).isNotEqualTo((Object)DUMMY_HOSTNAME);
        }
        finally {
            DNS.setCachedHostname((String)oldHostname);
        }
    }

    @Test(timeout=60000L)
    public void testLookupWithoutHostsFallback() throws Exception {
        String oldHostname = DNS.getCachedHostname();
        try {
            DNS.setCachedHostname((String)DUMMY_HOSTNAME);
            String hostname = DNS.getDefaultHost((String)this.getLoopbackInterface(), (String)INVALID_DNS_SERVER, (boolean)false);
            Assertions.assertThat((String)hostname).isEqualTo((Object)DUMMY_HOSTNAME);
        }
        finally {
            DNS.setCachedHostname((String)oldHostname);
        }
    }

    private String getLoopbackInterface() throws SocketException {
        return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress()).getName();
    }

    @Test
    public void testLocalhostResolves() throws Exception {
        InetAddress localhost = InetAddress.getByName("localhost");
        Assert.assertNotNull((String)"localhost is null", (Object)localhost);
        LOG.info("Localhost IPAddr is " + localhost.toString());
    }
}

