/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.KerberosAuthException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.event.Level;

public class TestUGILoginFromKeytab {
    private MiniKdc kdc;
    private File workDir;
    private ExecutorService executor;
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void startMiniKdc() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        this.workDir = this.folder.getRoot();
        this.kdc = new MiniKdc(MiniKdc.createConf(), this.workDir);
        this.kdc.start();
        this.executor = Executors.newCachedThreadPool();
    }

    @After
    public void stopMiniKdc() {
        if (this.kdc != null) {
            this.kdc.stop();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test
    public void testUGILoginFromKeytab() throws Exception {
        long beforeLogin = Time.now();
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = this.getUser(ugi.getSubject());
        Assert.assertNotNull((Object)user.getLogin());
        Assert.assertTrue((String)("User login time is less than before login time, beforeLoginTime:" + beforeLogin + " userLoginTime:" + user.getLastLogin()), (user.getLastLogin() > beforeLogin ? 1 : 0) != 0);
    }

    @Test
    public void testUGIReLoginFromKeytab() throws Exception {
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = this.getUser(ugi.getSubject());
        long firstLogin = user.getLastLogin();
        LoginContext login1 = user.getLogin();
        Assert.assertNotNull((Object)login1);
        Thread.sleep(2000L);
        ugi.reloginFromKeytab();
        long secondLogin = user.getLastLogin();
        LoginContext login2 = user.getLogin();
        Assert.assertTrue((String)"User should have been able to relogin from keytab", (secondLogin > firstLogin ? 1 : 0) != 0);
        Assert.assertNotNull((Object)login2);
        Assert.assertNotSame((Object)login1, (Object)login2);
    }

    @Test
    public void testUGIForceReLoginFromKeytab() throws Exception {
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)false);
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = this.getUser(ugi.getSubject());
        long firstLogin = user.getLastLogin();
        LoginContext login1 = user.getLogin();
        Assert.assertNotNull((Object)login1);
        Thread.sleep(2000L);
        ugi.forceReloginFromKeytab();
        long secondLogin = user.getLastLogin();
        LoginContext login2 = user.getLogin();
        Assert.assertTrue((String)"User should have been able to relogin from keytab", (secondLogin > firstLogin ? 1 : 0) != 0);
        Assert.assertNotNull((Object)login2);
        Assert.assertNotSame((Object)login1, (Object)login2);
    }

    @Test
    public void testGetUGIFromKnownSubject() throws Exception {
        KerberosPrincipal principal = new KerberosPrincipal("user");
        File keytab = new File(this.workDir, "user.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal.getName()});
        UserGroupInformation ugi1 = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal.getName(), (String)keytab.getPath());
        Subject subject = ugi1.getSubject();
        User user = this.getUser(subject);
        Assert.assertNotNull((Object)user);
        LoginContext login = user.getLogin();
        Assert.assertNotNull((Object)login);
        UserGroupInformation ugi2 = UserGroupInformation.getUGIFromSubject((Subject)subject);
        Assert.assertSame((Object)user, (Object)this.getUser(ugi2.getSubject()));
        Assert.assertSame((Object)login, (Object)user.getLogin());
    }

    @Test
    public void testGetUGIFromExternalSubject() throws Exception {
        KerberosPrincipal principal = new KerberosPrincipal("user");
        File keytab = new File(this.workDir, "user.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal.getName()});
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal.getName(), (String)keytab.getPath());
        Subject subject = ugi.getSubject();
        this.removeUser(subject);
        UserGroupInformation ugi1 = UserGroupInformation.getUGIFromSubject((Subject)subject);
        Assert.assertSame((Object)subject, (Object)ugi1.getSubject());
        User user = this.getUser(subject);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)principal.getName(), (Object)user.getName());
        Assert.assertNull((Object)user.getLogin());
        UserGroupInformation ugi2 = UserGroupInformation.getUGIFromSubject((Subject)subject);
        Assert.assertSame((Object)subject, (Object)ugi2.getSubject());
        Assert.assertSame((Object)user, (Object)this.getUser(ugi2.getSubject()));
        Assert.assertNull((Object)user.getLogin());
    }

    @Test
    public void testGetUGIFromExternalSubjectWithLogin() throws Exception {
        KerberosPrincipal principal = new KerberosPrincipal("user");
        File keytab = new File(this.workDir, "user.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal.getName()});
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal.getName(), (String)keytab.getPath());
        Subject subject = ugi.getSubject();
        User user = this.getUser(subject);
        LoginContext dummyLogin = (LoginContext)Mockito.mock(LoginContext.class);
        user.setLogin(dummyLogin);
        UserGroupInformation ugi2 = UserGroupInformation.getUGIFromSubject((Subject)subject);
        Assert.assertSame((Object)subject, (Object)ugi2.getSubject());
        Assert.assertSame((Object)user, (Object)this.getUser(ugi2.getSubject()));
        Assert.assertSame((Object)dummyLogin, (Object)user.getLogin());
    }

    @Test
    public void testUGIRefreshFromKeytab() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.kerberos.keytab.login.autorenewal.enabled", true);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        String principal = "bar";
        File keytab = new File(this.workDir, "bar.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertTrue((boolean)ugi.isFromKeytab());
        Assert.assertTrue((boolean)UserGroupInformation.isKerberosKeyTabLoginRenewalEnabled());
        Assert.assertTrue((boolean)UserGroupInformation.getKerberosLoginRenewalExecutor().isPresent());
    }

    @Test
    public void testUGIRefreshFromKeytabDisabled() throws Exception {
        GenericTestUtils.setLogLevel(UserGroupInformation.LOG, Level.DEBUG);
        Configuration conf = new Configuration();
        conf.setLong("hadoop.kerberos.min.seconds.before.relogin", 1L);
        conf.setBoolean("hadoop.kerberos.keytab.login.autorenewal.enabled", false);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        String principal = "bar";
        File keytab = new File(this.workDir, "bar.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertTrue((boolean)ugi.isFromKeytab());
        Assert.assertFalse((boolean)UserGroupInformation.isKerberosKeyTabLoginRenewalEnabled());
        Assert.assertFalse((boolean)UserGroupInformation.getKerberosLoginRenewalExecutor().isPresent());
    }

    private static KerberosTicket getTicket(UserGroupInformation ugi) {
        Set<KerberosTicket> tickets = ugi.getSubject().getPrivateCredentials(KerberosTicket.class);
        return tickets.isEmpty() ? null : tickets.iterator().next();
    }

    private static KerberosTicket checkTicketAndKeytab(UserGroupInformation ugi, KerberosPrincipal principal, boolean expectIsKeytab) {
        Assert.assertEquals((String)"wrong principal", (Object)principal.getName(), (Object)ugi.getUserName());
        Assert.assertEquals((String)"is not keytab", (Object)expectIsKeytab, (Object)ugi.isFromKeytab());
        KerberosTicket ticket = TestUGILoginFromKeytab.getTicket(ugi);
        Assert.assertNotNull((String)"no ticket", (Object)ticket);
        Assert.assertEquals((String)"wrong principal", (Object)principal, (Object)ticket.getClient());
        return ticket;
    }

    @Test
    public void testReloginForUGIFromSubject() throws Exception {
        final KerberosPrincipal principal1 = new KerberosPrincipal("user1");
        File keytab1 = new File(this.workDir, "user1.keytab");
        this.kdc.createPrincipal(keytab1, new String[]{principal1.getName()});
        final KerberosPrincipal principal2 = new KerberosPrincipal("user2");
        File keytab2 = new File(this.workDir, "user2.keytab");
        this.kdc.createPrincipal(keytab2, new String[]{principal2.getName()});
        final Subject extSubject = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal2.getName(), (String)keytab2.getPath()).getSubject();
        this.removeUser(extSubject);
        UserGroupInformation.loginUserFromKeytab((String)principal1.getName(), (String)keytab1.getPath());
        final UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        loginUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                KerberosTicket loginTicket = TestUGILoginFromKeytab.checkTicketAndKeytab(loginUser, principal1, true);
                UserGroupInformation extSubjectUser = UserGroupInformation.getUGIFromSubject((Subject)extSubject);
                KerberosTicket ticket = TestUGILoginFromKeytab.checkTicketAndKeytab(extSubjectUser, principal2, false);
                loginUser.reloginFromKeytab();
                KerberosTicket newLoginTicket = TestUGILoginFromKeytab.checkTicketAndKeytab(loginUser, principal1, true);
                Assert.assertNotEquals((Object)loginTicket.getAuthTime(), (Object)newLoginTicket.getAuthTime());
                extSubjectUser.reloginFromKeytab();
                Assert.assertSame((Object)ticket, (Object)TestUGILoginFromKeytab.checkTicketAndKeytab(extSubjectUser, principal2, false));
                Assert.assertSame((Object)newLoginTicket, (Object)TestUGILoginFromKeytab.checkTicketAndKeytab(loginUser, principal1, true));
                return null;
            }
        });
    }

    @Test
    public void testReloginForLoginFromSubject() throws Exception {
        final KerberosPrincipal principal1 = new KerberosPrincipal("user1");
        File keytab1 = new File(this.workDir, "user1.keytab");
        this.kdc.createPrincipal(keytab1, new String[]{principal1.getName()});
        final KerberosPrincipal principal2 = new KerberosPrincipal("user2");
        final File keytab2 = new File(this.workDir, "user2.keytab");
        this.kdc.createPrincipal(keytab2, new String[]{principal2.getName()});
        UserGroupInformation.loginUserFromKeytab((String)principal1.getName(), (String)keytab1.getPath());
        final UserGroupInformation originalLoginUser = UserGroupInformation.getLoginUser();
        Assert.assertNotNull((Object)this.getUser(originalLoginUser.getSubject()).getLogin());
        originalLoginUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                KerberosTicket originalLoginUserTicket = TestUGILoginFromKeytab.checkTicketAndKeytab(originalLoginUser, principal1, true);
                Subject subject = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal2.getName(), (String)keytab2.getPath()).getSubject();
                TestUGILoginFromKeytab.this.removeUser(subject);
                UserGroupInformation.loginUserFromSubject((Subject)subject);
                Assert.assertNull((Object)TestUGILoginFromKeytab.this.getUser(subject).getLogin());
                UserGroupInformation extLoginUser = UserGroupInformation.getLoginUser();
                KerberosTicket extLoginUserTicket = TestUGILoginFromKeytab.checkTicketAndKeytab(extLoginUser, principal2, false);
                extLoginUser.reloginFromKeytab();
                Assert.assertSame((Object)extLoginUserTicket, (Object)TestUGILoginFromKeytab.checkTicketAndKeytab(extLoginUser, principal2, false));
                Assert.assertSame((Object)originalLoginUserTicket, (Object)TestUGILoginFromKeytab.checkTicketAndKeytab(originalLoginUser, principal1, true));
                originalLoginUser.reloginFromKeytab();
                Assert.assertNotSame((Object)originalLoginUserTicket, (Object)TestUGILoginFromKeytab.checkTicketAndKeytab(originalLoginUser, principal1, true));
                Assert.assertSame((Object)extLoginUserTicket, (Object)TestUGILoginFromKeytab.checkTicketAndKeytab(extLoginUser, principal2, false));
                return null;
            }
        });
    }

    @Test
    public void testReloginAfterFailedRelogin() throws Exception {
        KerberosPrincipal principal = new KerberosPrincipal("user1");
        File keytab = new File(this.workDir, "user1.keytab");
        File keytabBackup = new File(keytab + ".backup");
        this.kdc.createPrincipal(keytab, new String[]{principal.getName()});
        UserGroupInformation.loginUserFromKeytab((String)principal.getName(), (String)keytab.getPath());
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        TestUGILoginFromKeytab.checkTicketAndKeytab(loginUser, principal, true);
        Assert.assertTrue((boolean)keytab.renameTo(keytabBackup));
        try {
            loginUser.reloginFromKeytab();
            Assert.fail((String)"relogin should fail");
        }
        catch (KerberosAuthException kerberosAuthException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)loginUser.isFromKeytab());
        Assert.assertNull((Object)TestUGILoginFromKeytab.getTicket(loginUser));
        Assert.assertTrue((boolean)keytabBackup.renameTo(keytab));
        loginUser.reloginFromKeytab();
        TestUGILoginFromKeytab.checkTicketAndKeytab(loginUser, principal, true);
    }

    @Test(timeout=180000L)
    public void testConcurrentRelogin() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch latch = new CountDownLatch(1);
        Assert.assertTrue((boolean)UserGroupInformation.isSecurityEnabled());
        final KerberosPrincipal principal = new KerberosPrincipal("testUser");
        File keytab = new File(this.workDir, "user1.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal.getName()});
        final UserGroupInformation loginUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal.getName(), (String)keytab.getPath());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)loginUgi.getAuthenticationMethod());
        Assert.assertTrue((boolean)loginUgi.isFromKeytab());
        final UserGroupInformation clonedUgi = UserGroupInformation.getUGIFromSubject((Subject)loginUgi.getSubject());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)clonedUgi.getAuthenticationMethod());
        Assert.assertTrue((boolean)clonedUgi.isFromKeytab());
        User user = this.getUser(loginUgi.getSubject());
        LoginContext spyLogin = (LoginContext)Mockito.spy((Object)user.getLogin());
        user.setLogin(spyLogin);
        ((LoginContext)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                invocation.callRealMethod();
                latch.countDown();
                barrier.await();
                return null;
            }
        }).when((Object)spyLogin)).logout();
        Future<Void> relogin = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Thread.currentThread().setName("relogin");
                loginUgi.reloginFromKeytab();
                return null;
            }
        });
        Assert.assertTrue((String)"first relogin didn't block", (boolean)latch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)clonedUgi.isFromKeytab());
        ((LoginContext)Mockito.doNothing().when((Object)spyLogin)).logout();
        ((LoginContext)Mockito.doNothing().when((Object)spyLogin)).login();
        Future<UserGroupInformation> clonedRelogin = this.executor.submit(new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                Thread.currentThread().setName("clonedRelogin");
                clonedUgi.reloginFromKeytab();
                return clonedUgi;
            }
        });
        try {
            clonedRelogin.get(2L, TimeUnit.SECONDS);
            Assert.fail((String)"second relogin didn't block!");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        loginUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                Assert.assertEquals((Object)principal.getName(), (Object)ugi.getUserName());
                Assert.assertTrue((boolean)ugi.isFromKeytab());
                return null;
            }
        });
        clonedUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                Assert.assertEquals((Object)principal.getName(), (Object)ugi.getUserName());
                Assert.assertTrue((boolean)ugi.isFromKeytab());
                return null;
            }
        });
        Assert.assertFalse((boolean)clonedRelogin.isDone());
        barrier.await();
        relogin.get();
        clonedRelogin.get();
    }

    private User getUser(Subject subject) {
        Iterator<User> iter = subject.getPrincipals(User.class).iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    private void removeUser(Subject subject) {
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof User)) continue;
            iter.remove();
        }
    }
}

