/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.buffertofile.DataSerializer;
import com.github.davidmoten.rx.internal.operators.NullSentinel;
import com.github.davidmoten.rx.internal.operators.QueueWithResources;
import com.github.davidmoten.util.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

class FileBasedSPSCQueue<T>
implements QueueWithResources<T> {
    final File file;
    final DataSerializer<T> serializer;
    final AtomicLong size;
    final byte[] writeBuffer;
    final byte[] readBuffer;
    final Object writeLock = new Object();
    private final Object accessLock = new Object();
    private final DataOutputStream output;
    private final DataInputStream input;
    int readBufferPosition = 0;
    long readPosition = 0L;
    int readBufferLength = 0;
    volatile long writePosition;
    volatile int writeBufferPosition;
    private FileAccessor accessor;
    private volatile boolean unsubscribed = false;
    private static final EOFException EOF = new EOFException();

    FileBasedSPSCQueue(int bufferSizeBytes, File file, DataSerializer<T> serializer) {
        Preconditions.checkArgument(bufferSizeBytes > 0, "bufferSizeBytes must be greater than zero");
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(serializer);
        this.readBuffer = new byte[bufferSizeBytes];
        this.writeBuffer = new byte[bufferSizeBytes];
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            this.file = file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.accessor = new FileAccessor(file);
        this.serializer = serializer;
        this.size = new AtomicLong(0L);
        this.output = new DataOutputStream(new QueueWriter());
        this.input = new DataInputStream(new QueueReader());
    }

    private static int toUnsignedInteger(byte b) {
        return b & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        if (this.unsubscribed) {
            return;
        }
        this.unsubscribed = true;
        Object object = this.accessLock;
        synchronized (object) {
            if (this.accessor != null) {
                this.accessor.close();
                this.accessor = null;
            }
            this.size.set(0L);
        }
        if (!this.file.delete()) {
            throw new RuntimeException("could not delete file " + this.file);
        }
    }

    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    @Override
    public boolean offer(T t) {
        try {
            this.serializer.serialize(this.output, t);
            this.size.incrementAndGet();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T poll() {
        try {
            T t = this.serializer.deserialize(this.input);
            this.size.decrementAndGet();
            if (t == null) {
                return NullSentinel.instance();
            }
            return t;
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeResources() {
        Object object = this.accessLock;
        synchronized (object) {
            if (this.accessor != null) {
                this.accessor.close();
            }
            this.accessor = null;
        }
    }

    @Override
    public long resourcesSize() {
        return this.writePosition;
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private final class QueueReader
    extends InputStream {
        private QueueReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            int b;
            boolean writeBufferUnchanged;
            if (FileBasedSPSCQueue.this.size.get() == 0L) {
                throw EOF;
            }
            if (FileBasedSPSCQueue.this.readBufferPosition < FileBasedSPSCQueue.this.readBufferLength) {
                byte b2 = FileBasedSPSCQueue.this.readBuffer[FileBasedSPSCQueue.this.readBufferPosition];
                ++FileBasedSPSCQueue.this.readBufferPosition;
                return FileBasedSPSCQueue.toUnsignedInteger(b2);
            }
            do {
                int wbp;
                long wp;
                Object object = FileBasedSPSCQueue.this.writeLock;
                synchronized (object) {
                    wp = FileBasedSPSCQueue.this.writePosition;
                    wbp = FileBasedSPSCQueue.this.writeBufferPosition;
                }
                long over = wp - FileBasedSPSCQueue.this.readPosition;
                if (over > 0L) {
                    FileBasedSPSCQueue.this.readBufferLength = (int)Math.min((long)FileBasedSPSCQueue.this.readBuffer.length, over);
                    Object object2 = FileBasedSPSCQueue.this.accessLock;
                    synchronized (object2) {
                        if (FileBasedSPSCQueue.this.accessor == null) {
                            FileBasedSPSCQueue.this.accessor = new FileAccessor(FileBasedSPSCQueue.this.file);
                        }
                        ((FileBasedSPSCQueue)FileBasedSPSCQueue.this).accessor.fRead.seek(FileBasedSPSCQueue.this.readPosition);
                        ((FileBasedSPSCQueue)FileBasedSPSCQueue.this).accessor.fRead.read(FileBasedSPSCQueue.this.readBuffer, 0, FileBasedSPSCQueue.this.readBufferLength);
                    }
                    FileBasedSPSCQueue.this.readPosition += (long)FileBasedSPSCQueue.this.readBufferLength;
                    FileBasedSPSCQueue.this.readBufferPosition = 1;
                    return FileBasedSPSCQueue.toUnsignedInteger(FileBasedSPSCQueue.this.readBuffer[0]);
                }
                int index = -((int)over);
                if (index >= FileBasedSPSCQueue.this.writeBuffer.length) {
                    throw EOF;
                }
                b = FileBasedSPSCQueue.toUnsignedInteger(FileBasedSPSCQueue.this.writeBuffer[index]);
                Object object3 = FileBasedSPSCQueue.this.writeLock;
                synchronized (object3) {
                    writeBufferUnchanged = wp == FileBasedSPSCQueue.this.writePosition && wbp == FileBasedSPSCQueue.this.writeBufferPosition;
                }
            } while (!writeBufferUnchanged);
            ++FileBasedSPSCQueue.this.readPosition;
            return b;
        }
    }

    private final class QueueWriter
    extends OutputStream {
        private QueueWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            int wbp = FileBasedSPSCQueue.this.writeBufferPosition;
            if (wbp < FileBasedSPSCQueue.this.writeBuffer.length) {
                FileBasedSPSCQueue.this.writeBuffer[wbp] = (byte)b;
                FileBasedSPSCQueue.this.writeBufferPosition = wbp + 1;
            } else {
                Object object = FileBasedSPSCQueue.this.writeLock;
                synchronized (object) {
                    long wp = FileBasedSPSCQueue.this.writePosition;
                    ((FileBasedSPSCQueue)FileBasedSPSCQueue.this).accessor.fWrite.seek(wp);
                    ((FileBasedSPSCQueue)FileBasedSPSCQueue.this).accessor.fWrite.write(FileBasedSPSCQueue.this.writeBuffer);
                    FileBasedSPSCQueue.this.writeBuffer[0] = (byte)b;
                    FileBasedSPSCQueue.this.writeBufferPosition = 1;
                    FileBasedSPSCQueue.this.writePosition = wp + (long)FileBasedSPSCQueue.this.writeBuffer.length;
                }
            }
        }
    }

    private static final class FileAccessor {
        final RandomAccessFile fWrite;
        final RandomAccessFile fRead;

        FileAccessor(File file) {
            try {
                this.fWrite = new RandomAccessFile(file, "rw");
                this.fRead = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            try {
                this.fWrite.close();
                this.fRead.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

