/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.Iterator;
import java.util.List;

public final class Permutations {
    private Permutations() {
    }

    public static <T> Iterable<Swap<T>> iterable(final List<T> list) {
        return new Iterable<Swap<T>>(){

            @Override
            public Iterator<Swap<T>> iterator() {
                return new PermutationsSwapIterator(list);
            }
        };
    }

    public static <T> Iterator<Swap<T>> iterator(List<T> list) {
        return new PermutationsSwapIterator<T>(list);
    }

    private static class DirectedReference {
        private final int reference;
        private int direction;

        DirectedReference(int direction, int reference) {
            this.direction = direction;
            this.reference = reference;
        }

        public void reverse() {
            this.direction = -this.direction;
        }

        public String toString() {
            String val = String.valueOf(this.reference);
            String result = this.direction == -1 ? "<" + val : val + ">";
            return result + String.valueOf(this.reference);
        }
    }

    public static class Swap<T> {
        private final T left;
        private final T right;

        Swap(T left, T right) {
            this.left = left;
            this.right = right;
        }

        public T left() {
            return this.left;
        }

        public T right() {
            return this.right;
        }

        public String toString() {
            return "Swap [left=" + this.left + ", right=" + this.right + "]";
        }
    }

    private static class PermutationsSwapIterator<T>
    implements Iterator<Swap<T>> {
        private final T[] values;
        private final DirectedReference[] references;

        public PermutationsSwapIterator(List<T> list) {
            this.values = list.toArray();
            this.references = new DirectedReference[list.size()];
            for (int i = 0; i < this.references.length; ++i) {
                this.references[i] = new DirectedReference(-1, i);
            }
        }

        private boolean isMobile(int index) {
            if (index == 0 && this.references[index].direction == -1) {
                return false;
            }
            if (index == this.references.length - 1 && this.references[index].direction == 1) {
                return false;
            }
            return this.references[index + this.references[index].direction].reference <= this.references[index].reference;
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.references.length; ++i) {
                if (!this.isMobile(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Swap<T> next() {
            int chosen = Integer.MIN_VALUE;
            int chosenIndex = -1;
            for (int i = 0; i < this.references.length; ++i) {
                if (!this.isMobile(i) || this.references[i].reference <= chosen) continue;
                chosen = this.references[i].reference;
                chosenIndex = i;
            }
            int neighbourIndex = chosenIndex + this.references[chosenIndex].direction;
            Swap<T> swap = new Swap<T>(this.values[this.references[chosenIndex].reference], this.values[this.references[neighbourIndex].reference]);
            DirectedReference tmp = this.references[chosenIndex];
            this.references[chosenIndex] = this.references[neighbourIndex];
            this.references[neighbourIndex] = tmp;
            for (int i = 0; i < this.references.length; ++i) {
                if (this.references[i].reference <= chosen) continue;
                this.references[i].reverse();
            }
            return swap;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove from permutations");
        }
    }
}

