/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.service.utils.ApplicationReportSerDeser;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SerializedApplicationReport {
    public String applicationId;
    public String applicationAttemptId;
    public String name;
    public String applicationType;
    public String user;
    public String queue;
    public String host;
    public Integer rpcPort;
    public String state;
    public String diagnostics;
    public String url;
    public Long submitTime;
    public Long startTime;
    public Long finishTime;
    public String finalStatus;
    public String origTrackingUrl;
    public Float progress;

    public SerializedApplicationReport() {
    }

    public SerializedApplicationReport(ApplicationReport report) {
        this.applicationId = report.getApplicationId().toString();
        ApplicationAttemptId attemptId = report.getCurrentApplicationAttemptId();
        this.applicationAttemptId = attemptId != null ? attemptId.toString() : "N/A";
        this.name = report.getName();
        this.applicationType = report.getApplicationType();
        this.user = report.getUser();
        this.queue = report.getQueue();
        this.host = report.getHost();
        this.rpcPort = report.getRpcPort();
        this.state = report.getYarnApplicationState().toString();
        this.diagnostics = report.getDiagnostics();
        this.startTime = report.getStartTime();
        this.finishTime = report.getFinishTime();
        FinalApplicationStatus appStatus = report.getFinalApplicationStatus();
        this.finalStatus = appStatus == null ? "" : appStatus.toString();
        this.progress = Float.valueOf(report.getProgress());
        this.url = report.getTrackingUrl();
        this.origTrackingUrl = report.getOriginalTrackingUrl();
    }

    public String toString() {
        try {
            return ApplicationReportSerDeser.toString(this);
        }
        catch (IOException e) {
            return super.toString();
        }
    }
}

