/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.xml;

import java.math.BigInteger;
import java.time.Duration;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import org.apache.hadoop.shaded.org.ehcache.config.EvictionAdvisor;
import org.apache.hadoop.shaded.org.ehcache.config.builders.CacheConfigurationBuilder;
import org.apache.hadoop.shaded.org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.apache.hadoop.shaded.org.ehcache.core.config.ExpiryUtils;
import org.apache.hadoop.shaded.org.ehcache.expiry.ExpiryPolicy;
import org.apache.hadoop.shaded.org.ehcache.xml.XmlConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.XmlModel;
import org.apache.hadoop.shaded.org.ehcache.xml.exceptions.XmlConfigurationException;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheTemplate;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.Expiry;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ExpiryType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.TimeType;

public class CoreCacheConfigurationParser {
    public <K, V> CacheConfigurationBuilder<K, V> parseConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Expiry parsedExpiry = cacheDefinition.expiry();
        if (parsedExpiry != null) {
            cacheBuilder = ((CacheConfigurationBuilder)cacheBuilder).withExpiry(CoreCacheConfigurationParser.getExpiry(cacheClassLoader, parsedExpiry));
        }
        EvictionAdvisor evictionAdvisor = CoreCacheConfigurationParser.getInstanceOfName(cacheDefinition.evictionAdvisor(), cacheClassLoader, EvictionAdvisor.class);
        cacheBuilder = ((CacheConfigurationBuilder)cacheBuilder).withEvictionAdvisor(evictionAdvisor);
        return cacheBuilder;
    }

    private static ExpiryPolicy<? super Object, ? super Object> getExpiry(ClassLoader cacheClassLoader, Expiry parsedExpiry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (parsedExpiry.isUserDef()) {
            try {
                return CoreCacheConfigurationParser.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, ExpiryPolicy.class);
            }
            catch (ClassCastException e) {
                return ExpiryUtils.convertToExpiryPolicy(CoreCacheConfigurationParser.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, org.apache.hadoop.shaded.org.ehcache.expiry.Expiry.class));
            }
        }
        if (parsedExpiry.isTTL()) {
            return ExpiryPolicyBuilder.timeToLiveExpiration(Duration.of(parsedExpiry.value(), parsedExpiry.unit()));
        }
        if (parsedExpiry.isTTI()) {
            return ExpiryPolicyBuilder.timeToIdleExpiration(Duration.of(parsedExpiry.value(), parsedExpiry.unit()));
        }
        return ExpiryPolicyBuilder.noExpiration();
    }

    static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (name == null) {
            return null;
        }
        Class<?> klazz = XmlConfiguration.getClassForName(name, classLoader);
        return klazz.asSubclass(type).newInstance();
    }

    public CacheType unparseConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        EvictionAdvisor<?, ?> evictionAdvisor;
        ExpiryPolicy<?, ?> expiryPolicy = cacheConfiguration.getExpiryPolicy();
        if (expiryPolicy != null) {
            Duration expiry = expiryPolicy.getExpiryForCreation(null, null);
            ExpiryType expiryType = new ExpiryType();
            if (expiryPolicy.equals(ExpiryPolicy.NO_EXPIRY)) {
                expiryType.withNone(new ExpiryType.None());
            } else if (expiryPolicy.equals(ExpiryPolicyBuilder.timeToLiveExpiration(expiry))) {
                expiryType.withTtl(CoreCacheConfigurationParser.convertToTimeType(expiry));
            } else if (expiryPolicy.equals(ExpiryPolicyBuilder.timeToIdleExpiration(expiry))) {
                expiryType.withTti(CoreCacheConfigurationParser.convertToTimeType(expiry));
            } else {
                throw new XmlConfigurationException("XML translation of custom expiry policy is not supported");
            }
            cacheType.withExpiry(expiryType);
        }
        if ((evictionAdvisor = cacheConfiguration.getEvictionAdvisor()) != null) {
            throw new XmlConfigurationException("XML translation of eviction advisor is not supported");
        }
        return cacheType;
    }

    private static TimeType convertToTimeType(Duration duration) {
        return Stream.of(TimeUnit.values()).sorted(Comparator.comparing(unit -> unit.convert(duration.toNanos(), TimeUnit.NANOSECONDS))).filter(unit -> duration.equals(Duration.of(unit.convert(duration.toNanos(), TimeUnit.NANOSECONDS), ExpiryUtils.jucTimeUnitToTemporalUnit(unit)))).findFirst().map(unit -> new TimeType().withValue(BigInteger.valueOf(unit.convert(duration.toNanos(), TimeUnit.NANOSECONDS))).withUnit(XmlModel.convertToXmlTimeUnit(unit))).orElseThrow(AssertionError::new);
    }
}

