/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrivilegedOperation {
    public static final char LINUX_FILE_PATH_SEPARATOR = '%';
    public static final String CGROUP_ARG_PREFIX = "cgroups=";
    public static final String CGROUP_ARG_NO_TASKS = "none";
    private final OperationType opType;
    private final List<String> args;
    private boolean failureLogging;

    public PrivilegedOperation(OperationType opType) {
        this.opType = opType;
        this.args = new ArrayList<String>();
        this.failureLogging = true;
    }

    public PrivilegedOperation(OperationType opType, String arg) {
        this(opType);
        if (arg != null) {
            this.args.add(arg);
        }
    }

    public PrivilegedOperation(OperationType opType, List<String> args) {
        this(opType);
        if (args != null) {
            this.args.addAll(args);
        }
    }

    public void appendArgs(String ... args) {
        for (String arg : args) {
            this.args.add(arg);
        }
    }

    public void appendArgs(List<String> args) {
        this.args.addAll(args);
    }

    public void enableFailureLogging() {
        this.failureLogging = true;
    }

    public void disableFailureLogging() {
        this.failureLogging = false;
    }

    public boolean isFailureLoggingEnabled() {
        return this.failureLogging;
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    public List<String> getArguments() {
        return Collections.unmodifiableList(this.args);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PrivilegedOperation)) {
            return false;
        }
        PrivilegedOperation otherOp = (PrivilegedOperation)other;
        return otherOp.opType.equals((Object)this.opType) && otherOp.args.equals(this.args);
    }

    public int hashCode() {
        return this.opType.hashCode() + 97 * this.args.hashCode();
    }

    public static enum ResultCode {
        OK(0),
        INVALID_USER_NAME(2),
        UNABLE_TO_EXECUTE_CONTAINER_SCRIPT(7),
        INVALID_CONTAINER_PID(9),
        INVALID_CONTAINER_EXEC_PERMISSIONS(22),
        INVALID_CONFIG_FILE(24),
        WRITE_CGROUP_FAILED(27);

        private final int value;

        private ResultCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum RunAsUserCommand {
        INITIALIZE_CONTAINER(0),
        LAUNCH_CONTAINER(1),
        SIGNAL_CONTAINER(2),
        DELETE_AS_USER(3),
        LAUNCH_DOCKER_CONTAINER(4),
        LIST_AS_USER(5),
        SYNC_YARN_SYSFS(6);

        private int value;

        private RunAsUserCommand(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OperationType {
        CHECK_SETUP("--checksetup"),
        MOUNT_CGROUPS("--mount-cgroups"),
        INITIALIZE_CONTAINER(""),
        LAUNCH_CONTAINER(""),
        SIGNAL_CONTAINER(""),
        EXEC_CONTAINER("--exec-container"),
        DELETE_AS_USER(""),
        LAUNCH_DOCKER_CONTAINER(""),
        TC_MODIFY_STATE("--tc-modify-state"),
        TC_READ_STATE("--tc-read-state"),
        TC_READ_STATS("--tc-read-stats"),
        ADD_PID_TO_CGROUP(""),
        RUN_DOCKER_CMD("--run-docker"),
        GPU("--module-gpu"),
        FPGA("--module-fpga"),
        DEVICE("--module-devices"),
        LIST_AS_USER(""),
        ADD_NUMA_PARAMS(""),
        REMOVE_DOCKER_CONTAINER("--remove-docker-container"),
        INSPECT_DOCKER_CONTAINER("--inspect-docker-container"),
        SYNC_YARN_SYSFS(""),
        RUN_RUNC_CONTAINER("--run-runc-container"),
        REAP_RUNC_LAYER_MOUNTS("--reap-runc-layer-mounts");

        private final String option;

        private OperationType(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }
    }
}

