/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.alexaforbusiness.model.SkillSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSkillsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SkillSummary> skillSummaries;
    private String nextToken;

    public List<SkillSummary> getSkillSummaries() {
        return this.skillSummaries;
    }

    public void setSkillSummaries(Collection<SkillSummary> skillSummaries) {
        if (skillSummaries == null) {
            this.skillSummaries = null;
            return;
        }
        this.skillSummaries = new ArrayList<SkillSummary>(skillSummaries);
    }

    public ListSkillsResult withSkillSummaries(SkillSummary ... skillSummaries) {
        if (this.skillSummaries == null) {
            this.setSkillSummaries(new ArrayList<SkillSummary>(skillSummaries.length));
        }
        for (SkillSummary ele : skillSummaries) {
            this.skillSummaries.add(ele);
        }
        return this;
    }

    public ListSkillsResult withSkillSummaries(Collection<SkillSummary> skillSummaries) {
        this.setSkillSummaries(skillSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSkillsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSkillSummaries() != null) {
            sb.append("SkillSummaries: ").append(this.getSkillSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsResult)) {
            return false;
        }
        ListSkillsResult other = (ListSkillsResult)obj;
        if (other.getSkillSummaries() == null ^ this.getSkillSummaries() == null) {
            return false;
        }
        if (other.getSkillSummaries() != null && !other.getSkillSummaries().equals(this.getSkillSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSkillSummaries() == null ? 0 : this.getSkillSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSkillsResult clone() {
        try {
            return (ListSkillsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

